<?php

namespace App\Entity;

use App\Entity\Common\DatesTrait;
use App\Entity\Common\IdTrait;
use App\Repository\ClientsentreprisesRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

#[ORM\Entity(repositoryClass: ClientsentreprisesRepository::class)]
#[ORM\HasLifecycleCallbacks]
#[ORM\UniqueConstraint(name: 'UNIQ_IDENTIFIER_EMAIL', fields: ['email'])]
class Clientsentreprises
{
    use DatesTrait;
    use IdTrait;

    #[ORM\Column(type: 'string', length: 255, nullable: false)]
    #[Assert\NotBlank]
    private ?string $rcc = null;

    #[ORM\Column(type: 'string', length: 255, nullable: false)]
    #[Assert\NotBlank]
    private ?string $nom = null;

    #[ORM\Column(type: 'string', length: 255, nullable: false)]
    #[Assert\NotBlank]
    private ?string $telephone = null;

    #[ORM\Column(type: 'text', nullable: false)]
    private ?string $adresse = null;

    #[ORM\Column(type: 'string', length: 255, nullable: true)]
    #[Assert\Email]
    private ?string $email = null;

    #[ORM\ManyToOne(targetEntity: Users::class, inversedBy: 'clientsentreprises')]
    private ?Users $users = null;

    #[ORM\OneToMany(targetEntity: Proformaentreprises::class, mappedBy: 'clients')]
    private Collection $proformaentreprises;

    #[ORM\OneToMany(targetEntity: Emailclientsentreprises::class, mappedBy: 'clientsentreprises')]
    private Collection $emailclientsentreprises;

    public function __construct()
    {
        $this->proformaentreprises = new ArrayCollection();
        $this->emailclientsentreprises = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getRcc(): ?string
    {
        return $this->rcc;
    }

    public function setRcc(string $rcc): self
    {
        $this->rcc = $rcc;

        return $this;
    }

    public function getNom(): ?string
    {
        return $this->nom;
    }

    public function setNom(string $nom): self
    {
        $this->nom = $nom;

        return $this;
    }

    public function getTelephone(): ?string
    {
        return $this->telephone;
    }

    public function setTelephone(string $telephone): self
    {
        $this->telephone = $telephone;

        return $this;
    }

    public function getAdresse(): ?string
    {
        return $this->adresse;
    }

    public function setAdresse(?string $adresse): self
    {
        $this->adresse = $adresse;

        return $this;
    }

    public function getUsers(): ?Users
    {
        return $this->users;
    }

    public function setUsers(?Users $users): self
    {
        $this->users = $users;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(string $email): self
    {
        $this->email = $email;

        return $this;
    }

    /**
     * @return Collection<int, Proformaentreprises>
     */
    public function getProformaentreprises(): Collection
    {
        return $this->proformaentreprises;
    }

    public function addProformaentreprise(Proformaentreprises $proformaentreprise): self
    {
        if (!$this->proformaentreprises->contains($proformaentreprise)) {
            $this->proformaentreprises[] = $proformaentreprise;
            $proformaentreprise->setClients($this);
        }

        return $this;
    }

    public function removeProformaentreprise(Proformaentreprises $proformaentreprise): self
    {
        if ($this->proformaentreprises->contains($proformaentreprise)) {
            $this->proformaentreprises->removeElement($proformaentreprise);
            if ($proformaentreprise->getClients() === $this) {
                $proformaentreprise->setClients(null);
            }
        }

        return $this;
    }

    public function __toString()
    {
        return $this->nom;
    }

    /**
     * @return Collection<int, Emailclientsentreprises>
     */
    public function getEmailclientsentreprises(): Collection
    {
        return $this->emailclientsentreprises;
    }

    public function addEmailclientsentreprise(Emailclientsentreprises $emailclientsentreprise): self
    {
        if (!$this->emailclientsentreprises->contains($emailclientsentreprise)) {
            $this->emailclientsentreprises[] = $emailclientsentreprise;
            $emailclientsentreprise->setClientsentreprises($this);
        }

        return $this;
    }

    public function removeEmailclientsentreprise(Emailclientsentreprises $emailclientsentreprise): self
    {
        if ($this->emailclientsentreprises->contains($emailclientsentreprise)) {
            $this->emailclientsentreprises->removeElement($emailclientsentreprise);
            if ($emailclientsentreprise->getClientsentreprises() === $this) {
                $emailclientsentreprise->setClientsentreprises(null);
            }
        }

        return $this;
    }
}
