<?php

namespace App\Services;

use App\Entity\Parametres;
use Psr\Container\ContainerInterface;
use Spipu\Html2Pdf\Html2Pdf;
use Symfony\Component\HttpFoundation\Response;


class getBonlivraison
{

    private $container;
    private $entitymanager;

    /**
     * getProformas constructor.
     * @param ContainerInterface $container
     * @param $entitymanager
     */
    public function __construct(ContainerInterface $container, $entitymanager)
    {
        $this->container = $container;
        $this->entitymanager = $entitymanager;
    }

    /**
     * @param $proforma
     * @return Response
     * @throws \Spipu\Html2Pdf\Exception\Html2PdfException
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    public function facture($proforma)
    {
        $societe = $this->entitymanager->getRepository(Parametres::class)->findOneBy(['id' => 1]);
        
        $html = $this->container->get('twig')->render('pdf/proformas/entreprises/bonlivraison.html.twig', array('facture' => $proforma, 'societe' => $societe));

        $html2pdf = new Html2Pdf('P','A4','fr');
        $html2pdf->pdf->SetAuthor($societe->getName());
        $html2pdf->pdf->SetTitle('Proforma_ '.$proforma->getTitrefacture().'_'.$proforma->getClientsentreprises()->getNom());
        $html2pdf->pdf->SetSubject('Proforma_ '.$proforma->getTitrefacture().'_'.$proforma->getClientsentreprises()->getNom());
        $html2pdf->pdf->SetKeywords('proformas');
        $html2pdf->pdf->SetDisplayMode('real');
        $html2pdf->writeHTML($html);
        $proformatitre = str_replace(' ', '_', $proforma->getTitrefacture());
        $proformaName = str_replace(' ','_','Proforma_'.$proformatitre.'_'.$proforma->getClientsentreprises()->getNom());
        $html2pdf->output($proformaName.'.pdf', 'I');

        $response = new Response();

        $response->headers->set('Content-type', 'application/pdf');
        return $response;
    }
}