<?php

namespace App\Components\Admin;

use App\Entity\Proformaentreprises;
use App\Entity\Proformaparticuliers;
use App\Repository\ProformaentreprisesRepository;
use App\Repository\ProformaparticuliersRepository;
use Symfony\UX\TwigComponent\Attribute\AsTwigComponent;

#[AsTwigComponent('GetProformaByStatusComponent', template: 'components/admin/get_proforma_status_component.html.twig')]
readonly class GetProformaByStatusComponents
{
    public function __construct(
        private ProformaentreprisesRepository  $proformaentreprisesRepository,
        private ProformaparticuliersRepository $proformaparticuliersRepository,
    )
    {
    }

    /**
     * @return Proformaentreprises[]|null
     */
    public function getProformaEntrepriseByStatus(): ?array
    {
        return $this->proformaentreprisesRepository->getProformaStatus(status: false);
    }

    /**
     * @return Proformaparticuliers[]|null
     */
    public function getProformaParticulierByStatus(): ?array
    {
        return $this->proformaparticuliersRepository->getProformasStatus(status: false);
    }
}