<?php

namespace App\Components\Particuliers;

use App\Entity\Proformaparticuliers;
use App\Repository\ProformaparticuliersRepository;
use Symfony\UX\TwigComponent\Attribute\AsTwigComponent;

#[AsTwigComponent('DataParticuliersDashboardComponent', template: 'components/particuliers/data_particuliers_dashboard_component.html.twig')]
readonly class DataParticuliersDashboardComponents
{
    public function __construct(private ProformaparticuliersRepository $proformaparticuliersRepository)
    {
    }

    /**
     * @return Proformaparticuliers[]|null
     */
    public function proformaParticuliersToday(): ?array
    {
        return $this->proformaparticuliersRepository->findToday();
    }

    /**
     * @return Proformaparticuliers[]|null
     */
    public function proformaParticuliersYesterday(): ?array
    {
        return $this->proformaparticuliersRepository->findYesterday();
    }

    public function countProformaParticuliersValider(): int
    {
        return $this->proformaparticuliersRepository->countProformaParticuliersStatus(status: true);
    }

    public function countProformaParticuliersInvalider(): int
    {
        return $this->proformaparticuliersRepository->countProformaParticuliersStatus(status: false);
    }
}