<?php

namespace App\Components\Searchs;

use App\Entity\ClientsSearch;
use App\Form\ClientsSearchType;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Form\FormInterface;
use Symfony\UX\LiveComponent\Attribute\AsLiveComponent;
use Symfony\UX\LiveComponent\Attribute\LiveProp;
use Symfony\UX\LiveComponent\ComponentWithFormTrait;
use Symfony\UX\LiveComponent\DefaultActionTrait;

#[AsLiveComponent('ClientSearchFormComponent', template: 'components/searchs/client_search_form_component.html.twig')]
class ClientSearchFormComponents extends AbstractController
{
    use DefaultActionTrait;
    use ComponentWithFormTrait;

    #[LiveProp]
    public ?ClientsSearch $search = null;

    protected function instantiateForm(): FormInterface
    {
        return $this->createForm(ClientsSearchType::class, $this->search);
    }
}