<?php

namespace App\Entity;

use App\Entity\Common\DatesTrait;
use App\Entity\Common\IdTrait;
use App\Repository\EmailclientsentreprisesRepository;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

#[ORM\Entity(repositoryClass: EmailclientsentreprisesRepository::class)]
#[ORM\HasLifecycleCallbacks]
#[ORM\UniqueConstraint(name: 'UNIQ_IDENTIFIER_EMAIL', fields: ['email'])]
class Emailclientsentreprises
{
    use DatesTrait;
    use IdTrait;

    #[ORM\Column(type: 'string', length: 255)]
    #[Assert\Email]
    private ?string $email = null;

    private ?string $objet = null;

    private ?string $filename = null;

    private ?string $message = null;

    #[ORM\ManyToOne(targetEntity: Clientsentreprises::class, inversedBy: 'emailclientsentreprises')]
    private ?Clientsentreprises $clientsentreprises = null;

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(string $email): self
    {
        $this->email = $email;

        return $this;
    }

    public function getClientsentreprises(): ?Clientsentreprises
    {
        return $this->clientsentreprises;
    }

    public function setClientsentreprises(?Clientsentreprises $clientsentreprises): self
    {
        $this->clientsentreprises = $clientsentreprises;

        return $this;
    }

    public function getObjet(): ?string
    {
        return $this->objet;
    }

    public function setObjet(?string $objet): static
    {
        $this->objet = $objet;
        return $this;
    }

    public function getFilename(): ?string
    {
        return $this->filename;
    }

    public function setFilename(?string $filename): static
    {
        $this->filename = $filename;
        return $this;
    }

    public function getMessage(): ?string
    {
        return $this->message;
    }

    public function setMessage(?string $message): static
    {
        $this->message = $message;
        return $this;
    }

    public function __toString()
    {
        return $this->email;
    }
}
