<?php

namespace App\Form;

use App\Entity\Departements;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class DepartementsType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('nomdepartement', null, ['label' => 'Nom du département', 'attr' => [
                'placeholder' => 'Nom du département',
                'class' => 'input-xs',
            ]])
            ->add('responsable', null, ['label' => 'Nom du responsable', 'attr' => [
                'placeholder' => 'Nom du responsable',
                'class' => 'input-xs',
            ]])
            ->add('telephone', null, ['label' => 'Téléphone du responsable', 'attr' => [
                'placeholder' => 'Téléphone du responsable',
                'class' => 'input-xs',
            ]]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Departements::class,
        ]);
    }
}
