<?php

namespace App\Form;

use App\Entity\Clientsentreprises;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class EmailEntreprisesType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('clientsentreprises', EntityType::class, [
                'class' => 'App\Entity\Clientsentreprises',
                'label' => 'Clients',
                'placeholder' => 'Sélectionnez un client',
                'required' => true,
                'attr' => ['class' => 'default-select2']
            ])
            ->add('email', EntityType::class, [
                'label' => 'Email',
                'required' => true,
                'multiple' => true,
                'class' => 'App\Entity\Emailclientsentreprises',
                'placeholder' => 'Sélectionner vos adresses emails ici...',
                'choices' => [],
                'attr' => ['class' => ''],
            ])
            ->add('objet', null, ['label' => 'Objet', 'attr' => [
                'placeholder' => 'Objet du message',
                'class' => 'input-xs',
            ]])
            ->add('filename', FileType::class, ['label' => 'Fichier', 'required' => false, 'attr' => [
                'class' => 'input-xs',
            ]])
            ->add('message', TextareaType::class, ['label' => 'Message', 'attr' => [
                'placeholder' => 'Votre message',
                'class' => 'input-xs summernote',
            ]]);

        $builder->get('clientsentreprises')->addEventListener(
            FormEvents::POST_SUBMIT,
            function (FormEvent $event) {
                $form = $event->getForm();
                $this->addEmailField($form->getParent(), $form->getData());
            }
        );
    }

    /**
     * Ajoute un champ Type de formation au formulaire
     *
     * @param FormInterface $form
     * @param Clientsentreprises|null $clientsentreprises
     */
    private function addEmailField(FormInterface $form, ?Clientsentreprises $clientsentreprises): void
    {
        $builder = $form->getConfig()->getFormFactory()->createNamedBuilder(
            'email',
            EntityType::class,
            null,
            [
                'class' => 'App\Entity\Emailclientsentreprises',
                'placeholder' => $clientsentreprises ? 'Choisissez un ou plusieurs email' : 'Email',
                'label' => 'Emails clients',
                'mapped' => false,
                'multiple' => true,
                'auto_initialize' => false,
                'required' => true,
                'choices' => $clientsentreprises ? $clientsentreprises->getEmailclientsentreprises() : [],
                'attr' => ['class' => ''],
            ]
        );
        $form->add($builder->getForm());
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'csrf_protection' => true,
        ]);
    }
}
