<?php

namespace App\Form;

use App\Entity\ClientsSearch;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class SearchClientsType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('nom', SearchClientsType::class, [
                'required' => true,
                'label' => false,
                'attr' => [
                    'placeholder' => 'Rechercher un client',
                    'class' => 'input-xs',
                    'autocomplete' => 'off',
                ],
            ])
            ->add('clienttype', ChoiceType::class, [
                'multiple' => true,
                'expanded' => true,
                'choices' => [0 => 'Entreprise', 1 => 'Particulier'],
                'attr' => ['class' => 'input-xs', 'Placeholder' => 'Sélectionner un type de client'],
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => ClientsSearch::class,
            'method' => 'get',
            'csrf_protection' => false,
        ]);
    }

    public function getBlockPrefix(): string
    {
        return '';
    }
}
