<?php

namespace App\Repository;

use App\Entity\PaiementParticulier;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<PaiementParticulier>
 */
class PaiementParticulierRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, PaiementParticulier::class);
    }

    /**
     * @param $datedebut
     * @param $datefin
     * @param $id
     * @return PaiementParticulier|null
     */
    public function findPaiementByPeriodeAndUser($datedebut, $datefin, $id): ?array
    {
        return $this->createQueryBuilder('p')
            ->andWhere('p.user = :idUser')
            ->setParameter('idUser', $id)
            ->andWhere('p.laDate >= :datedebut')
            ->setParameter('datedebut', $datedebut)
            ->andWhere('p.laDate <= :datefin')
            ->setParameter('datefin', $datefin)
            ->orderBy('p.id', 'DESC')
            ->getQuery()
            ->getResult();
    }

    /**
     * @param $datedebut
     * @param $datefin
     * @return PaiementParticulier[]|null
     */
    public function findPaiementByPeriode($datedebut, $datefin): ?array
    {
        return $this->createQueryBuilder('p')
            ->andWhere('p.laDate >= :datedebut')
            ->setParameter('datedebut', $datedebut)
            ->andWhere('p.laDate <= :datefin')
            ->setParameter('datefin', $datefin)
            ->orderBy('p.id', 'DESC')
            ->getQuery()
            ->getResult();
    }

    /**
     * @param $datedebut
     * @param $datefin
     * @param $client
     * @return PaiementParticulier[]|null
     */
    public function findPaiementByPeriodeAndGroupUser($datedebut, $datefin, $client): ?array
    {
        return $this->createQueryBuilder('p')
            ->leftJoin('p.proformaParticulier', 'pro')
            ->select('pro.nom as nom, sum(p.montant) as montant, p.laDate as laDate, count(pro.id) as nombrePrestation')
            ->where('p.laDate >= :datedebut')
            ->setParameter('datedebut', $datedebut)
            ->andWhere('p.laDate <= :datefin')
            ->setParameter('datefin', $datefin)
            ->andWhere('pro.nom LIKE :client')
            ->setParameter('client', '%' . $client . '%')
            ->groupby('nom')
            ->getQuery()->getResult();
    }

}
