<?php declare(strict_types=1);

namespace App\Services\Helpers;

use NumberToWords\Exception\InvalidArgumentException;
use NumberToWords\Exception\NumberToWordsException;
use NumberToWords\NumberToWords;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RequestStack;

readonly class HelpersServices implements HelpersInterfaces
{
    public function __construct(private RequestStack $requestStack)
    {
    }

    /**
     * @param float $numberToConvert
     * @param string|null $devise
     * @return string
     * @throws InvalidArgumentException
     * @throws NumberToWordsException
     */
    public function tocurrency(float $numberToConvert, ?string $devise = 'XOF'): string
    {
        if (!$devise) {
            return '';
        }
        $montant = 0;
        if ($numberToConvert) {
            $montant = $montant + ($numberToConvert * 100);
        } else {
            $montant = $montant + $numberToConvert;
        }
        /** @var Request $request */
        $request = $this->requestStack->getCurrentRequest();
        $locale = $request->getLocale();
        $numberToWords = new NumberToWords();
        $currencyTransformer = $numberToWords->getCurrencyTransformer($locale);
        return $currencyTransformer->toWords(intval($montant), $devise);
    }

    /**
     * @param int $numberToConvert
     * @return string
     * @throws InvalidArgumentException
     * @throws NumberToWordsException
     */
    public function towords(int $numberToConvert): string
    {
        /** @var Request $request */
        $request = $this->requestStack->getCurrentRequest();
        $locale = $request->getLocale();
        $numberToWords = new NumberToWords();
        $numberTransformer = $numberToWords->getNumberTransformer($locale);
        return $numberTransformer->toWords($numberToConvert);
    }
}