<?php

namespace App\Services;

use Spipu\Html2Pdf\Html2Pdf;
use Symfony\Component\HttpFoundation\Response;


class Pdf
{
    private $pdf;

    private $autor;
    private $title;
    private $subject;
    private $keyword;
    private $displaymode;

    /**
     * @param null $oriantation
     * @param null $format
     * @param null $lang
     * @param null $unicode
     * @param null $encoding
     * @param null $margin
     */
    public function create($oriantation = null, $format = null, $lang = null, $unicode = null, $encoding = null, $margin = null)
    {
        $this->pdf = new Html2Pdf(
            $oriantation ? $oriantation : $this->orientation,
            $format ? $format : $this->format,
            $lang ? $lang : $this->lang,
            $unicode ? $unicode : $this->unicode,
            $encoding ? $encoding : $this->encoding,
            $margin ? $margin : $this->margin
        );
    }

    public function generatePDF($template, $name){
        $this->pdf->writeHTML($template);
        $response = new Response();
        $response->headers->set('Content-type', 'application/pdf');
        //dd($response);
        return $this->pdf->Output($name.'.pdf', 'D');
    }

    /**
     * @return mixed
     */
    public function getAutor()
    {
        return $this->autor;
    }

    /**
     * @param mixed $autor
     * @return Pdf
     */
    public function setAutor($autor)
    {
        $this->autor = $this->pdf->SetAuthor($autor);
        return $this;
    }

    /**
     * @return mixed
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param mixed $title
     * @return Pdf
     */
    public function setTitle($title)
    {
        $this->title = $this->pdf->SetTitle($title);;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getSubject()
    {
        return $this->subject;
    }

    /**
     * @param mixed $subject
     * @return Pdf
     */
    public function setSubject($subject)
    {
        $this->subject = $this->pdf->SetSubject($subject);
        return $this;
    }

    /**
     * @return mixed
     */
    public function getKeyword()
    {
        return $this->keyword;
    }

    /**
     * @param mixed $keyword
     * @return Pdf
     */
    public function setKeyword($keyword)
    {
        $this->keyword = $this->pdf->SetKeywords($keyword);
        return $this;
    }

    /**
     * @return mixed
     */
    public function getDisplaymode()
    {
        return $this->displaymode;
    }

    /**
     * @param mixed $displaymode
     * @return Pdf
     */
    public function setDisplaymode($displaymode)
    {
        $this->displaymode = $this->pdf->SetDisplayMode($displaymode);
        return $this;
    }
}