<?php

declare(strict_types=1);

namespace App\Subscriber;

use App\Entity\Proformaentreprises;
use App\Services\Helpers\HelpersInterfaces;
use Doctrine\Bundle\DoctrineBundle\Attribute\AsDoctrineListener;
use Doctrine\ORM\Event\PreUpdateEventArgs;

#[AsDoctrineListener('preUpdate')]
readonly class ProformaEntreprisesPreUpdateSubscriber
{

    public function __construct(private HelpersInterfaces $helper)
    {
    }

    public function preUpdate(PreUpdateEventArgs $event): void
    {
        $entity = $event->getObject();

        if (!($entity instanceof Proformaentreprises)) {
            return;
        }

        $montantlettre = strtoupper($this->helper->towords($entity->getTotalttc()));
        $entity->setMontantlettre($montantlettre);
        $entity->setResteAPayer($entity->getTotalttc() - $entity->getMontantpaye());
    }
}
