<?php

namespace App\Components\Admin;

use App\Repository\ProformaentreprisesRepository;
use App\Repository\ProformaparticuliersRepository;
use Symfony\UX\TwigComponent\Attribute\AsTwigComponent;

#[AsTwigComponent('CountProformaStatusComponent', template: 'components/admin/count_proforma_status_component.html.twig')]
readonly class CountProformaStatusComponents
{
    public function __construct(
        private ProformaentreprisesRepository  $proformaentreprisesRepository,
        private ProformaparticuliersRepository $proformaparticuliersRepository,
    )
    {
    }

    public function countProformaEntrepriseByStatus(): int
    {
        return $this->proformaentreprisesRepository->countProformaByStatus(status: false);
    }

    public function countProformaParticulierByStatus(): int
    {
        return $this->proformaparticuliersRepository->countProformaByStatus(status: false);
    }
}