<?php

namespace App\Components\Admin;

use App\Repository\ClientsentreprisesRepository;
use App\Repository\ProformaentreprisesRepository;
use App\Repository\ProformaparticuliersRepository;
use Symfony\UX\TwigComponent\Attribute\AsTwigComponent;

#[AsTwigComponent('CountStatistiqueComponent', template: 'components/admin/count_statistique_component.html.twig')]
readonly class CountStatistiqueComponents
{
    public function __construct(
        private ClientsentreprisesRepository   $clientsentreprisesRepository,
        private ProformaentreprisesRepository  $proformaentreprisesRepository,
        private ProformaparticuliersRepository $proformaparticuliersRepository,
    )
    {
    }

    public function countClientsEntreprises(): int
    {
        return $this->clientsentreprisesRepository->countAll();
    }

    public function countProformaEntreprises(): int
    {
        return $this->proformaentreprisesRepository->countAll();
    }

    public function countProformaParticuliers(): int
    {
        return $this->proformaparticuliersRepository->countAll();
    }
}