<?php

namespace App\Components\Entreprises;

use App\Entity\Proformaentreprises;
use App\Repository\ClientsentreprisesRepository;
use App\Repository\ProformaentreprisesRepository;
use Symfony\UX\TwigComponent\Attribute\AsTwigComponent;

#[AsTwigComponent('StatsEntreprisesComponent', template: 'components/entreprises/stats_entreprises_component.html.twig')]
readonly class StatsEntreprisesComponents
{
    public function __construct(
        private ProformaentreprisesRepository $proformaentreprisesRepository,
        private ClientsentreprisesRepository  $clientsentreprisesRepository,
    )
    {
    }

    /**
     * @return Proformaentreprises[]|null
     */
    public function sommeTotalProformaEntreprises(): ?array
    {
        return $this->proformaentreprisesRepository->findSumTotal();
    }

    public function countClientsEntreprises(): int
    {
        return $this->clientsentreprisesRepository->countAll();
    }
}