<?php

namespace App\Components\Particuliers;

use App\Entity\Proformaparticuliers;
use App\Repository\ProformaparticuliersRepository;
use Symfony\UX\TwigComponent\Attribute\AsTwigComponent;

#[AsTwigComponent('StatsParticuliersComponent', template: 'components/particuliers/stats_particuliers_component.html.twig')]
readonly class StatsParticuliersComponents
{
    public function __construct(
        private ProformaparticuliersRepository $proformaparticuliersRepository
    )
    {
    }

    public function factureJournaliers(): ?array
    {
        return $this->proformaparticuliersRepository->findFacturesJournaliers();
    }

    public function facturesHebdomadaires(): ?array
    {
        return $this->proformaparticuliersRepository->findFacturesHebdomadaire();
    }

    public function facturesMensuels(): ?array
    {
        return $this->proformaparticuliersRepository->findFacturesMensuel();
    }

    /**
     * @return Proformaparticuliers[]|null
     */
    public function sommeTotalProformaParticuliers(): ?array
    {
        return $this->proformaparticuliersRepository->findSumTotal();
    }
}