<?php

namespace App\Controller;

use App\Entity\Users;
use App\Form\UsersComptesType;
use App\Managers\Managers;
use App\Services\Helpers\FlashServiceInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Routing\Requirement\Requirement;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[Route('/dashboard/users/compte')]
#[IsGranted(new Expression('is_granted("ROLE_SUPER_ADMIN") or is_granted("ROLE_ENTREPRISE") or is_granted("ROLE_PARTICULIER")'))]
class CompteController extends AbstractController
{
    public function __construct(
        private readonly Managers              $manager,
        private readonly FlashServiceInterface $flash,
    )
    {
    }

    #[Route('/{id}/edit', name: 'users.comptes.edit', requirements: ['id' => Requirement::DIGITS], methods: ['GET', 'POST'])]
    public function editCompte(Request $request, Users $user): Response
    {
        $form = $this->createForm(UsersComptesType::class, $user);
        $form->handleRequest($request);
        if ($form->isSubmitted()) {
            $user->setUsername(strtolower($form->get('username')->getData()));
            $user->setEmail(strtolower($form->get('email')->getData()));
            $this->manager->setEntity($user, 'edit');
            $this->flash->success("Modification effectuée avec succès.");
            return $this->redirectToRoute('users.comptes.edit', [
                'id' => $user->getId(),
            ]);
        }

        return $this->render('admin/utilisateurs/comptes/edit.html.twig', [
            'user' => $user,
            'form' => $form->createView(),
            'title' => 'Editer un mon compte',
            'active' => 'users.comptes.edit',
        ]);
    }
}
