<?php

namespace App\Controller\Entreprises;

use App\Entity\Proformaentreprises;
use App\Form\Entreprises\AddProformaType;
use App\Managers\ManagersInterface;
use App\Repository\ProformaentreprisesRepository;
use App\Services\Carts\CartItem;
use App\Services\Carts\CartService;
use App\Services\Helpers\FlashServiceInterface;
use App\Services\Helpers\HelpersServices;
use NumberToWords\Exception\InvalidArgumentException;
use NumberToWords\Exception\NumberToWordsException;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[Route('/dashboard/entreprise/proformas')]
#[IsGranted(new Expression('is_granted("ROLE_SUPER_ADMIN") or is_granted("ROLE_ENTREPRISE")'))]
class ProformaController extends AbstractController
{
    public function __construct(
        private readonly HelpersServices               $helpersServices,
        private readonly CartService                   $cartService,
        private readonly ProformaentreprisesRepository $proformaentreprisesRepository,
        private readonly ManagersInterface             $manager,
        private readonly FlashServiceInterface         $flash,
    )
    {
    }

    /**
     * @throws NumberToWordsException
     * @throws InvalidArgumentException
     */
    #[Route('/save', name: "proforma.entreprises.save", methods: ['POST'])]
    public function save(Request $request): Response
    {
        $facture = new Proformaentreprises();
        $form = $this->createForm(AddProformaType::class, $facture);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {

            $tva = $this->cartService->tva();
            $remise = $this->cartService->discount();
            /** @var CartItem[] $carts */
            $carts = $this->cartService->getItems();
            $nombre = $this->helpersServices->generateNumeroProforma()[0];
            $numerolabel = $this->helpersServices->generateNumeroProforma()[1];
            $montantTva = $this->cartService->calculateTax($tva);
            $montantRemise = $this->cartService->calculateDiscount($remise);
            $totalHT = $this->cartService->getTotalHorsTaxe();
            $totalTTC = $this->cartService->getTotal();
            $proforma = $this->cartService->getDataForProforma($carts);

            //Preparation des données pour enregistrement
            $facture->setNumero($nombre);
            $facture->setNumerolabelle($numerolabel);
            $facture->setTotalht($totalHT);
            $facture->setTotalttc($totalTTC);
            $facture->setResteAPayer($totalTTC);
            $facture->setTva($tva);
            $facture->setRemise($remise);
            $facture->setProduits($proforma);
            $facture->setValider(false);
            $facture->setUsers($this->getUser());
            $facture->setEtat(0);
            $facture->setStatut(false);
            $facture->setMontantlettre($this->helpersServices->towords($totalTTC));
            $this->manager->setEntity($facture, 'new');

            $this->proformaentreprisesRepository->mettreClientAJour(
                $facture->getId(),
                $facture->getClientsentreprises()->getId()
            );
            //On vide la table panier
            $this->cartService->clear();
            $this->flash->success("Facture Enregistrée avec sucès.");
            return $this->redirectToRoute('entreprise.cart.index');
        }
        $this->flash->danger("Une erreur est survenue lors de l'enregistrement de la facture.");
        return $this->redirectToRoute('entreprise.cart.index');
    }
}
