<?php

namespace App\Controller\Particuliers;

use App\Entity\PeriodeProformaSearch;
use App\Entity\Proformaparticuliers;
use App\Form\Particuliers\ProformaPeriodeType;
use App\Repository\PaiementParticulierRepository;
use App\Repository\ProformaparticuliersRepository;
use App\Services\Helpers\FlashServiceInterface;
use App\Services\Proforma\ParticulierProformaService;
use DateTime;
use Exception;
use Spipu\Html2Pdf\Exception\Html2PdfException;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Routing\Requirement\Requirement;
use Symfony\Component\Security\Http\Attribute\IsGranted;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Error\SyntaxError;

#[Route('/dashboard/particulier/facture/impression')]
#[IsGranted(new Expression('is_granted("ROLE_SUPER_ADMIN") or is_granted("ROLE_PARTICULIER")'))]
class ImpressionParticuliersController extends AbstractController
{
    public function __construct(
        private readonly FlashServiceInterface          $flash,
        private readonly ParticulierProformaService     $particulierProformaService,
        private readonly ProformaparticuliersRepository $proformaparticuliersRepository,
        private readonly PaiementParticulierRepository  $paiementParticulierRepository,
    )
    {
    }

    #[Route('/periode', name: "particuliers.bilan.facture", methods: ['GET'])]
    public function index(): Response
    {
        $proformas = null;
        $moisEnCours = date('m');
        $anneeEnCours = date('Y');

        $anneeIntervalle = array();

        for ($i = 2010; $i <= $anneeEnCours; $i++) {
            $anneeIntervalle[] = $i;
        }
        for ($i = 2010; $i <= date('Y'); $i++) {
            $anneeIntervalle[] = $i;
        }
        $moisIntervalle = [
            '01' => 'Janvier',
            '02' => 'Février',
            '03' => 'Mars',
            '04' => 'Avril',
            '05' => 'Mai',
            '06' => 'Juin',
            '07' => 'Juillet',
            '08' => 'Août',
            '09' => 'Septembre',
            '10' => 'Octobre',
            '11' => 'Novembre',
            '12' => 'Décembre',
        ];

        return $this->render('particuliers/bilans/index.html.twig', [
            'proformas' => $proformas,
            'title' => 'Imprimer une facture pour une période donnée',
            'anneeEnCours' => $anneeEnCours,
            'moisEnCours' => $moisEnCours,
            'anneeIntervalle' => $anneeIntervalle,
            'moisIntervalle' => $moisIntervalle,
        ]);
    }

    /**
     * @throws Exception
     */
    #[Route('/search/periode', name: "proformaparticuliers.periode.pdf", methods: ['GET', 'POST'])]
    public function proformaPeriodeListe(Request $request): Response
    {
        $search = new PeriodeProformaSearch();
        $form_periode = $this->createForm(ProformaPeriodeType::class, $search);
        $form_periode->handleRequest($request);
        if ($form_periode->isSubmitted() && $form_periode->isValid()) {
            $datedebut = new DateTime($this->convertDateMysql($form_periode->get('datedebut')->getData()) . ' 00:00:00');
            $datefin = new DateTime($this->convertDateMysql($form_periode->get('datefin')->getData()) . ' 00:00:00');
            $proformas = $this->proformaparticuliersRepository->gtetProformaByPeriode($datedebut, $datefin);
            if (!$proformas)
                $this->flash->danger("Aucune facture trouvée.");
        } else {
            $proformas = null;
        }

        return $this->render('particuliers/bilans/index.html.twig', [
            'form_periode' => $form_periode->createView(),
            'proformas' => $proformas,
            'title' => 'Imprimer une facture pour une période donnée',
        ]);

    }

    private function convertDateMysql($date): string
    {
        $datebenutexplode = explode('/', $date);
        return $datebenutexplode[2] . '/' . $datebenutexplode[1] . '/' . $datebenutexplode[0];
    }

    /**
     * @throws Exception
     */
    #[Route('/search/periode-journalier', name: "proformaparticuliers.periode.journalier", methods: ['GET', 'POST'])]
    public function proformaPeriodeListeJournalier(Request $request): Response
    {
        $laDate = $request->request->get('laDate');
        $laDate = preg_replace("#(/)#", '-', $laDate);
        $dDebut = $laDate;
        $dFin = $laDate;

        $laDateEnObjet = new DateTime($laDate);

        $dateDebut = new DateTime($dDebut);
        $dateDebut->setTime(0, 0);
        $dateFin = new DateTime($dFin);
        $dateFin->setTime(23, 59, 59);
        $paiements = $this->paiementParticulierRepository->findPaiementByPeriode($dateDebut, $dateFin);

        return $this->render('particuliers/bilans/index_particulier.html.twig', [

            'paiements' => $paiements
        ]);

    }

    /**
     * @throws Exception
     */
    #[Route('/search/periode-mensuel', name: "proformaparticuliers.periode.mensuel", methods: ['GET', 'POST'])]
    public function proformaPeriodeListeMensuel(Request $request): Response
    {
        $nombreDeJour = [
            '01' => 31,
            '02' => 29,
            '03' => 31,
            '04' => 30,
            '05' => 31,
            '06' => 30,
            '07' => 31,
            '08' => 31,
            '09' => 30,
            '10' => 31,
            '11' => 30,
            '12' => 31
        ];
        $anneeMensuel = $request->request->get('anneeMensuel');
        $moisMensuel = $request->request->get('moisMensuel');
        $dateDebut = new DateTime($anneeMensuel . '-' . $moisMensuel . '-01');
        $dateFin = new DateTime($anneeMensuel . '-' . $moisMensuel . '-' . $nombreDeJour[$moisMensuel]);
        $paiements = $this->paiementParticulierRepository->findPaiementByPeriode($dateDebut, $dateFin);

        return $this->render('particuliers/bilans/index_particulier.html.twig', [
            'paiements' => $paiements
        ]);

    }

    /**
     * @throws Exception
     */
    #[Route('/search/periode-annuel', name: "proformaparticuliers.periode.annuel", methods: ['GET', 'POST'])]
    public function proformaPeriodeListeAnnuel(Request $request): Response
    {
        $anneeAnnuel = $request->request->get('anneeAnnuel');


        $dateDebut = new DateTime($anneeAnnuel . '-01-01');
        $dateFin = new DateTime($anneeAnnuel . '-12-31');
        $paiements = $this->paiementParticulierRepository->findPaiementByPeriode($dateDebut, $dateFin);

        return $this->render('particuliers/bilans/index_particulier.html.twig', [
            'paiements' => $paiements
        ]);
    }

    /**
     * @throws Exception
     */
    #[Route('/search/periode-by-employer', name: "proformaparticuliers.periode.paremployer", methods: ['GET', 'POST'])]
    public function proformaPeriodeListeParEmployer(Request $request): Response
    {
        $dDebut = $request->request->get('dateDebut');
        $dFin = $request->request->get('dateFin');
        $client = $request->request->get('client');
        $dDebut = preg_replace("#(/)#", '-', $dDebut);
        $dFin = preg_replace("#(/)#", '-', $dFin);
        $dateDebut = new DateTime($dDebut);
        $dateDebut->setTime(0, 0);
        $dateFin = new DateTime($dFin);
        $dateFin->setTime(23, 59, 59);

        $paiements = $this->paiementParticulierRepository->findPaiementByPeriodeAndGroupUser($dateDebut, $dateFin, $client);

        return $this->render('particuliers/bilans/bilan_par_client.html.twig', [
            'paiements' => $paiements
        ]);
    }

    /**
     * @throws SyntaxError
     * @throws Html2PdfException
     * @throws RuntimeError
     * @throws LoaderError
     */
    #[Route('/pdf-generate/{id}', name: "proformaparticulier.pdf", requirements: ['id' => Requirement::DIGITS], methods: ['GET'])]
    public function facturePDFActionParticulier(Proformaparticuliers $proformaparticuliers): Response
    {
        $facture = $this->proformaparticuliersRepository->findOneBy(['id' => $proformaparticuliers->getId()]);
        if (!$facture) {
            $this->flash->danger("Une erreur est survenue, veuillez réessayer.");
            return $this->redirect($this->generateUrl('proformaparticuliers.index'));
        }
        return $this->particulierProformaService->facture(
            proforma: $facture,
            template: 'pdf/proformas/particuliers/proformas.html.twig'
        );
    }

}
