<?php

namespace App\Controller\Particuliers;

use App\Entity\PaiementParticulier;
use App\Entity\Proformaparticuliers;
use App\Form\Particuliers\AddProformaType;
use App\Managers\ManagersInterface;
use App\Services\Carts\CartItem;
use App\Services\Carts\CartService;
use App\Services\Helpers\FlashServiceInterface;
use App\Services\Helpers\HelpersServices;
use NumberToWords\Exception\InvalidArgumentException;
use NumberToWords\Exception\NumberToWordsException;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[Route('/dashboard/particulier/proformas')]
#[IsGranted(new Expression('is_granted("ROLE_SUPER_ADMIN") or is_granted("ROLE_PARTICULIER")'))]
class ProformaController extends AbstractController
{
    public function __construct(
        private readonly HelpersServices       $helpersServices,
        private readonly CartService           $cartService,
        private readonly ManagersInterface     $manager,
        private readonly FlashServiceInterface $flash,
    )
    {
    }

    /**
     * @throws NumberToWordsException
     * @throws InvalidArgumentException
     */
    #[Route('/save', name: "proforma.particuliers.save", methods: ['POST'])]
    public function save(Request $request): Response
    {
        $facture = new Proformaparticuliers();
        $form = $this->createForm(AddProformaType::class, $facture);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $paiementparticulier = new Paiementparticulier;
            $tva = $this->cartService->tva();
            /** @var CartItem[] $carts */
            $carts = $this->cartService->getItems();
            $nombre = $this->helpersServices->generateNumeroProformaParticulier()[0];
            $numerolabel = $this->helpersServices->generateNumeroProformaParticulier()[1];
            $totalHT = $this->cartService->getTotalHorsTaxe();
            $totalTTC = $this->cartService->getTotal();
            $proforma = $this->cartService->getDataForProforma($carts);

            if ($facture->getResteAPayer() < 0) {
                $this->flash->danger("Montant payé supérieur au montant total.");
                return $this->redirectToRoute('particulier.cart.index');
            }

            if ($facture->getMontantpaye() > 0) {
                $paiementparticulier->setProformaParticulier($facture);
                $paiementparticulier->setMontant($facture->getMontantpaye());
                $paiementparticulier->setUser($this->getUser());
            }

            //Definition de l'année (2 derniers chiffres)
            $jour_mois = date('d/m');
            $codelabel = $nombre . '/' . $jour_mois;

            $facture->setUsers($this->getUser());
            $facture->setCode($nombre);
            $facture->setCodelabel($codelabel);

            //Preparation des données pour enregistrement
            $facture->setNumero($nombre);
            $facture->setNumerolabel($numerolabel);
            $facture->setTotalht($totalHT);
            $facture->setTotalttc($totalTTC);
            $facture->setTva($tva);
            $facture->setProduits($proforma);
            $facture->setValider(false);
            $facture->setUsers($this->getUser());
            $facture->setEtat(0);
            $facture->setStatut(1);
            $facture->setMontantlettre($this->helpersServices->towords($totalTTC));
            $this->manager->setEntity($facture, 'new');
            if ($facture->getMontantpaye() > 0) {
                $this->manager->setEntity($paiementparticulier, 'new');
            }

            //On vide la table panier
            $this->cartService->clear();
            $this->flash->success("Prestation Enregistrée avec sucès.");
            return $this->redirectToRoute('particulier.cart.index');
        }
        $this->flash->danger("Une erreur est survenue lors de l'enregistrement de la facture.");
        return $this->redirectToRoute('particulier.cart.index');
    }
}
