<?php

namespace App\Form\Entreprises;

use App\Entity\Clientsentreprises;
use App\Entity\Proformaentreprises;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class AddProformaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('nomdemandeur', null, ['label' => 'Nom du demandeur', 'attr' => [
                'placeholder' => 'Nom du demandeur',
                'class' => 'input-xs',
            ]])
            ->add('datefacture', DateType::class, [
                'widget' => 'single_text',
                'html5' => false,
                'format' => 'dd/MM/yyyy',
                'attr' => [
                    'class' => 'input-xs daterange-single -control'
                ]])
            ->add('clientsentreprises', EntityType::class, [
                'class' => Clientsentreprises::class,
                'choice_label' => 'nom',
                'placeholder' => 'Choisir un client',
                'required' => true,
                'attr' => [
                    'class' => 'form-control'
                ],
            ])
            ->add('titrefacture', null, ['label' => 'Titre', 'attr' => [
                'placeholder' => 'Titre de la facture',
                'class' => 'input-xs',
            ]])
            ->add('mentionvalidite', TextareaType::class, [
                'label' => 'Mention de validité',
                'data' => 'Cette proforma est valable  pour 30 jours à compter de la date d\'emission',
                'attr' => [
                    'placeholder' => 'Mention de validité',
                    'class' => 'input-xs',
                ]]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Proformaentreprises::class,
        ]);
    }
}
