<?php

namespace App\Form\Entreprises;

use App\Entity\Clientsentreprises;
use App\Entity\Proformaentreprises;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Vich\UploaderBundle\Form\Type\VichFileType;

class ProformaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('titrefacture', null, ['label' => 'Titre', 'attr' => [
                'placeholder' => 'Titre de la facture',
                'class' => 'input-xs',
            ]])
            ->add('montantlettre', null, ['label' => 'Montant total en lettre', 'attr' => [
                'placeholder' => 'Montant total en lettre',
                'class' => 'input-xs',
            ]])
            ->add('nomdemandeur', null, ['label' => 'Nom du demandeur', 'attr' => [
                'placeholder' => 'Nom du demandeur',
                'class' => 'input-xs',
            ]])
            ->add('mentionvalidite', TextareaType::class, [
                'label' => 'Mention de validité',
                'data' => 'Cette proforma n\'est valable que pour 30 jours à compter de la date d\'emission',
                'attr' => [
                    'placeholder' => 'Mention de validité',
                    'class' => 'input-xs',
                ]])
            ->add('etat', ChoiceType::class, [
                'choices' => $this->getChoices(),
                'label' => 'Etat de paiement',
                'placeholder' => 'Sélectionner un état de paiement',
                'attr' => ['class' => 'input-xs',],
            ])
            ->add('modereglements', null, ['label' => 'Mode de règlement', 'placeholder' => 'Sélectionner un mode de règlement', 'attr' => [
                'class' => 'input-xs',
            ]])
            ->add('montantpaye', null, ['label' => 'Montant payé', 'attr' => [
                'placeholder' => 'Montant payé',
                'class' => 'input-xs',
                'min' => 0,
            ]])
            ->add('clients', EntityType::class, array(
                'class' => Clientsentreprises::class,
                'placeholder' => 'Sélectionner un client',
                'label' => 'Clients',
                'attr' => ['class' => 'select-border-color border-success'],
            ))
            ->add('documentFile', VichFileType::class, [
                'required' => false,
                'attr' => [
                    'class' => 'file-styled-primary'
                ],
            ]);
    }

    private function getChoices(): array
    {
        $choices = Proformaentreprises::ETATPAIEMENTS;
        $output = [];
        foreach ($choices as $k => $v) {
            $output[$v] = $k;
        }
        return $output;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Proformaentreprises::class,
        ]);
    }
}
