<?php

namespace NumberToWords\NumberTransformer;

class KurdishNumberTransformerTest extends NumberTransformerTest
{
    protected function setUp(): void
    {
        $this->numberTransformer = new KurdishNumberTransformer();
    }

    public function providerItConvertsNumbersToWords(): array
    {
        return [
            [-3, 'سالب سێ'],
            [-9539, 'سالب نۆ هەزار و پێنج سەد و سی و نۆ'],
            [0, 'سفر'],
            [1, 'یەک'],
            [3, 'سێ'],
            [8, 'هەشت'],
            [9, 'نۆ'],
            [10, 'دە'],
            [11, 'یازدە'],
            [12, 'دوازدە'],
            [16, 'شازدە'],
            [19, 'نۆزدە'],
            [20, 'بیست'],
            [21, 'بیست و یەک'],
            [25, 'بیست و پێنج'],
            [26, 'بیست و شەش'],
            [30, 'سی'],
            [31, 'سی و یەک'],
            [40, 'چل'],
            [43, 'چل و سێ'],
            [50, 'پەنجا'],
            [55, 'پەنجا و پێنج'],
            [58, 'پەنجا و هەشت'],
            [60, 'شەست'],
            [67, 'شەست و حەوت'],
            [70, 'حەفتا'],
            [79, 'حەفتا و نۆ'],
            [80, 'هەشتا'],
            [90, 'نەوەد'],
            [99, 'نەوەد و نۆ'],
            [100, 'سەد'],
            [101, 'سەد و یەک'],
            [102, 'سەد و دوو'],
            [111, 'سەد و یازدە'],
            [113, 'سەد و سێزدە'],
            [120, 'سەد و بیست'],
            [121, 'سەد و بیست و یەک'],
            [199, 'سەد و نەوەد و نۆ'],
            [203, 'دوو سەد و سێ'],
            [229, 'دوو سەد و بیست و نۆ'],
            [287, 'دوو سەد و هەشتا و حەوت'],
            [300, 'سێ سەد'],
            [356, 'سێ سەد و پەنجا و شەش'],
            [410, 'چوار سەد و دە'],
            [434, 'چوار سەد و سی و چوار'],
            [500, 'پێنج سەد'],
            [578, 'پێنج سەد و حەفتا و هەشت'],
            [660, 'شەش سەد و شەست'],
            [666, 'شەش سەد و شەست و شەش'],
            [689, 'شەش سەد و هەشتا و نۆ'],
            [729, 'حەوت سەد و بیست و نۆ'],
            [894, 'هەشت سەد و نەوەد و چوار'],
            [900, 'نۆ سەد'],
            [909, 'نۆ سەد و نۆ'],
            [919, 'نۆ سەد و نۆزدە'],
            [990, 'نۆ سەد و نەوەد'],
            [999, 'نۆ سەد و نەوەد و نۆ'],
            [1000, 'یەک هەزار'],
            [1001, 'یەک هەزار و یەک'],
            [1010, 'یەک هەزار و دە'],
            [1015, 'یەک هەزار و پازدە'],
            [1097, 'یەک هەزار و نەوەد و حەوت'],
            [1100, 'یەک هەزار و سەد'],
            [1104, 'یەک هەزار و سەد و چوار'],
            [1111, 'یەک هەزار و سەد و یازدە'],
            [1243, 'یەک هەزار و دوو سەد و چل و سێ'],
            [2000, 'دوو هەزار'],
            [2385, 'دوو هەزار و سێ سەد و هەشتا و پێنج'],
            [3766, 'سێ هەزار و حەوت سەد و شەست و شەش'],
            [4000, 'چوار هەزار'],
            [4196, 'چوار هەزار و سەد و نەوەد و شەش'],
            [4538, 'چوار هەزار و پێنج سەد و سی و هەشت'],
            [5000, 'پێنج هەزار'],
            [5020, 'پێنج هەزار و بیست'],
            [5846, 'پێنج هەزار و هەشت سەد و چل و شەش'],
            [6459, 'شەش هەزار و چوار سەد و پەنجا و نۆ'],
            [7232, 'حەوت هەزار و دوو سەد و سی و دوو'],
            [8569, 'هەشت هەزار و پێنج سەد و شەست و نۆ'],
            [9539, 'نۆ هەزار و پێنج سەد و سی و نۆ'],
            [11000, 'یازدە هەزار'],
            [11001, 'یازدە هەزار و یەک'],
            [21000, 'بیست و یەک هەزار'],
            [21512, 'بیست و یەک هەزار و پێنج سەد و دوازدە'],
            [90000, 'نەوەد هەزار'],
            [92100, 'نەوەد و دوو هەزار و سەد'],
            [212112, 'دوو سەد و دوازدە هەزار و سەد و دوازدە'],
            [720018, 'حەوت سەد و بیست هەزار و هەژدە'],
            [999000, 'نۆ سەد و نەوەد و نۆ هەزار'],
            [999999, 'نۆ سەد و نەوەد و نۆ هەزار و نۆ سەد و نەوەد و نۆ'],
            [1000000, 'یەک ملیۆن'],
            [1001001, 'یەک ملیۆن و یەک هەزار و یەک'],
            [2000000, 'دوو ملیۆن'],
            [3248518, 'سێ ملیۆن و دوو سەد و چل و هەشت هەزار و پێنج سەد و هەژدە'],
            [4000000, 'چوار ملیۆن'],
            [5000000, 'پێنج ملیۆن'],
            [999000000, 'نۆ سەد و نەوەد و نۆ ملیۆن'],
            [999000999, 'نۆ سەد و نەوەد و نۆ ملیۆن و نۆ سەد و نەوەد و نۆ'],
            [999999000, 'نۆ سەد و نەوەد و نۆ ملیۆن و نۆ سەد و نەوەد و نۆ هەزار'],
            [999999999, 'نۆ سەد و نەوەد و نۆ ملیۆن و نۆ سەد و نەوەد و نۆ هەزار و نۆ سەد و نەوەد و نۆ'],
            [1174315110, 'یەک ملیار و سەد و حەفتا و چوار ملیۆن و سێ سەد و پازدە هەزار و سەد و دە'],
            [1174315119, 'یەک ملیار و سەد و حەفتا و چوار ملیۆن و سێ سەد و پازدە هەزار و سەد و نۆزدە'],
            [1800000006, 'یەک ملیار و هەشت سەد ملیۆن و شەش'],
            [15174315119, 'پازدە ملیار و سەد و حەفتا و چوار ملیۆن و سێ سەد و پازدە هەزار و سەد و نۆزدە'],
            [35174315119, 'سی و پێنج ملیار و سەد و حەفتا و چوار ملیۆن و سێ سەد و پازدە هەزار و سەد و نۆزدە'],
            [935174315119, 'نۆ سەد و سی و پێنج ملیار و سەد و حەفتا و چوار ملیۆن و سێ سەد و پازدە هەزار و سەد و نۆزدە'],
            [2935174315119, 'دوو تریلیۆن و نۆ سەد و سی و پێنج ملیار و سەد و حەفتا و چوار ملیۆن و سێ سەد و پازدە هەزار و سەد و نۆزدە'],
        ];
    }
}
