<?php

namespace App\Entity;

use App\Entity\Common\DatesTrait;
use App\Entity\Common\IdTrait;
use App\Repository\PaiementParticulierRepository;
use DateTimeImmutable;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

#[ORM\Entity(repositoryClass: PaiementParticulierRepository::class)]
#[ORM\HasLifecycleCallbacks]
class PaiementParticulier
{

    use DatesTrait;
    use IdTrait;

    #[ORM\Column(type: Types::FLOAT, precision: 10, scale: 0, nullable: true, options: ['default' => 0])]
    private ?float $montant = 0;

    #[ORM\ManyToOne(targetEntity: Users::class)]
    private ?Users $user = null;

    #[ORM\ManyToOne(targetEntity: Proformaparticuliers::class)]
    private ?Proformaparticuliers $proformaParticulier = null;

    #[ORM\Column(type: 'datetime_immutable', nullable: false)]
    #[Assert\NotBlank]
    private ?DateTimeImmutable $laDate;

    #[ORM\Column(type: 'text', nullable: true)]
    private ?string $detail = null;

    public function __construct()
    {
        $this->laDate = new DateTimeImmutable();
    }

    public function getProformaParticulier(): ?Proformaparticuliers
    {
        return $this->proformaParticulier;
    }

    public function setProformaParticulier(?Proformaparticuliers $proformaParticulier): self
    {
        $this->proformaParticulier = $proformaParticulier;

        return $this;
    }


    public function getUser(): ?Users
    {
        return $this->user;
    }

    public function setUser(?Users $user): self
    {
        $this->user = $user;

        return $this;
    }

    public function getLaDate(): ?DateTimeImmutable
    {
        return $this->laDate;
    }

    public function setLaDate(?DateTimeImmutable $laDate): PaiementParticulier
    {
        $this->laDate = $laDate;
        return $this;
    }


    public function getMontant(): ?int
    {
        return $this->montant;
    }

    public function setMontant(?int $montant): self
    {
        $this->montant = $montant;

        return $this;
    }

    public function getDetail(): ?string
    {
        return $this->detail;
    }

    public function setDetail(?string $detail): self
    {
        $this->detail = $detail;

        return $this;
    }

    public function __toString(): string
    {
        return $this->numeroFacture ?? '';
    }

}
