<?php

namespace App\Entity;

use App\Entity\Common\DatesTrait;
use App\Entity\Common\IdTrait;
use App\Repository\PaniersEntrepriseRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

#[ORM\Entity(repositoryClass: PaniersEntrepriseRepository::class)]
#[ORM\HasLifecycleCallbacks]
class PaniersEntreprise
{
    use DatesTrait;
    use IdTrait;

    #[ORM\Column(type: 'integer', nullable: false, options: ['default' => 0])]
    #[Assert\NotBlank]
    private ?int $quantite = 0;

    #[ORM\Column(type: 'text', nullable: false)]
    #[Assert\NotBlank]
    private ?string $designation = null;

    #[ORM\Column(type: Types::FLOAT, precision: 10, scale: 0, nullable: false, options: ['default' => 0])]
    #[Assert\NotBlank]
    private ?float $pu = 0;

    #[ORM\Column(type: Types::FLOAT, precision: 10, scale: 0, nullable: true, options: ['default' => 0])]
    private ?float $pt = 0;

    #[ORM\Column(type: 'integer', nullable: true)]
    private ?int $proformaid = null;

    #[ORM\ManyToOne(targetEntity: Users::class, inversedBy: 'paniersEntreprise')]
    private ?Users $users = null;

    public function __construct()
    {
        $this->users = $this->getUsers();
    }

    public function getUsers(): ?Users
    {
        return $this->users;
    }

    public function setUsers(?Users $users): self
    {
        $this->users = $users;

        return $this;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getQuantite(): ?float
    {
        return $this->quantite;
    }

    public function setQuantite(float $quantite): self
    {
        $this->quantite = $quantite;

        return $this;
    }

    public function getDesignation(): ?string
    {
        return $this->designation;
    }

    public function setDesignation(string $designation): self
    {
        $this->designation = $designation;

        return $this;
    }

    public function getPu(): ?float
    {
        return $this->pu;
    }

    public function setPu(float $pu): self
    {
        $this->pu = $pu;

        return $this;
    }

    public function getPt(): ?float
    {
        return $this->pt;
    }

    public function setPt(float $pt): self
    {
        $this->pt = $pt;

        return $this;
    }

    public function getProformaid(): ?int
    {
        return $this->proformaid;
    }

    public function setProformaid(?int $proformaid): self
    {
        $this->proformaid = $proformaid;

        return $this;
    }
}
