<?php

namespace App\Repository;

use App\Entity\PaiementEntreprise;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<PaiementEntreprise>
 */
class PaiementEntrepriseRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, PaiementEntreprise::class);
    }

    /**
     * @param $datedebut
     * @param $datefin
     * @param $id
     * @return PaiementEntreprise[]|null
     */
    public function findPaiementByPeriodeAndUser($datedebut, $datefin, $id): ?array
    {
        return $this->createQueryBuilder('p')
            ->andWhere('p.user = :idUser')
            ->setParameter('idUser', $id)
            ->andWhere('p.laDate >= :datedebut')
            ->setParameter('datedebut', $datedebut)
            ->andWhere('p.laDate <= :datefin')
            ->setParameter('datefin', $datefin)
            ->orderBy('p.id', 'DESC')
            ->getQuery()
            ->getResult();
    }

    /**
     * @return PaiementEntreprise[]
     */
    public function findPaiementByPeriode($datedebut, $datefin): array
    {
        return $this->createQueryBuilder('p')
            ->andWhere('p.laDate >= :datedebut')
            ->setParameter('datedebut', $datedebut)
            ->andWhere('p.laDate <= :datefin')
            ->setParameter('datefin', $datefin)
            ->orderBy('p.id', 'DESC')
            ->getQuery()
            ->getResult();
    }


    /**
     * @param $datedebut
     * @param $datefin
     * @return PaiementEntreprise[]|null
     */
    public function findPaiementByPeriodeAndGroupUser($datedebut, $datefin): ?array
    {
        return $this->createQueryBuilder('p')
            ->groupBy('p.user')
            ->andWhere('p.laDate >= :datedebut')
            ->setParameter('datedebut', $datedebut)
            ->andWhere('p.laDate <= :datefin')
            ->setParameter('datefin', $datefin)
            ->orderBy('p.laDate', 'DESC')
            ->getQuery()->getResult();
    }

}
