<?php

namespace App\Repository;

use App\Entity\PaniersParticulier;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<PaniersParticulier>
 */
class PaniersParticulierRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, PaniersParticulier::class);
    }

    public function findSum()
    {
        return $this->createQueryBuilder('p')
            ->select('SUM(p.pt) as somme')
            ->getQuery()
            ->getSingleResult();
    }

    public function clearPaniers()
    {
        $em = $this->getEntityManager();
        $sql = "TRUNCATE TABLE panier";
        $query = $em->createQuery($sql);

        return $query->getResult();
    }
}
