<?php

namespace App\Components\Commons;

use App\Services\Helpers\HelpersInterfaces;
use Symfony\UX\TwigComponent\Attribute\AsTwigComponent;

#[AsTwigComponent('CurrencyToWord', template: 'components/commons/currency_to_word_component.html.twig')]
class CurrencyToWordComponents
{
    public ?float $price = 0;
    public ?string $devise = 'XOF';

    public function __construct(private readonly HelpersInterfaces $helpersInterfaces)
    {
    }

    public function getToCurrency(): string
    {
        return $this->price != null ? $this->helpersInterfaces->tocurrency($this->price, $this->devise) : '';
    }
}