<?php

namespace App\Components\Entreprises;

use App\Entity\Proformaentreprises;
use App\Repository\ProformaentreprisesRepository;
use Symfony\UX\TwigComponent\Attribute\AsTwigComponent;

#[AsTwigComponent('DataEntreprisesDashboardComponent', template: 'components/entreprises/data_entreprises_dashboard_component.html.twig')]
readonly class DataEntreprisesDashboardComponents
{
    public function __construct(private ProformaentreprisesRepository $proformaentreprisesRepository)
    {
    }

    /**
     * @return Proformaentreprises[]|null
     */
    public function proformaEntreprisesToday(): ?array
    {
        return $this->proformaentreprisesRepository->findToday();
    }

    /**
     * @return Proformaentreprises[]|null
     */
    public function proformaEntreprisesYesterday(): ?array
    {
        return $this->proformaentreprisesRepository->findYesterday();
    }

    public function countProformaEntreprisesValider(): int
    {
        return $this->proformaentreprisesRepository->countProformaEntreprisesStatus(status: true);
    }

    public function countProformaEntreprisesInvalider(): int
    {
        return $this->proformaentreprisesRepository->countProformaEntreprisesStatus(status: false);
    }
}