<?php

namespace App\Controller\Admin;

use App\Entity\PeriodeProformaSearch;
use App\Entity\Users;
use App\Form\Entreprises\ProformaPeriodeType;
use App\Form\UsersComptesType;
use App\Managers\Managers;
use App\Services\Helpers\FlashServiceInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Routing\Requirement\Requirement;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[Route('/dashboard')]
#[IsGranted(new Expression('is_granted("ROLE_SUPER_ADMIN") or is_granted("ROLE_ENTREPRISE") or is_granted("ROLE_PARTICULIER")'))]
class AdminController extends AbstractController
{

    public function __construct(
        private readonly Managers              $manager,
        private readonly FlashServiceInterface $flash,
    )
    {
    }

    #[Route('/', name: 'home')]
    public function index(): Response
    {
        return $this->render('dashboard/index.html.twig', [
            'active' => 'home',
            'title' => 'Tableau de board',
        ]);
    }

    #[Route('/users/compte/{id}/edit', name: 'users.comptes.edit', requirements: ['id' => Requirement::DIGITS], methods: ['GET', 'POST'])]
    public function editCompte(Request $request, Users $user): Response
    {
        $form = $this->createForm(UsersComptesType::class, $user);
        $form->handleRequest($request);
        if ($form->isSubmitted()) {
            $user->setUsername(strtolower($form->get('username')->getData()));
            $user->setEmail(strtolower($form->get('email')->getData()));
            $this->manager->setEntity($user, 'edit');
            $this->flash->success("Modification effectuée avec succès.");
            return $this->redirectToRoute('users.comptes.edit', [
                'id' => $user->getId(),
            ]);
        }

        return $this->render('admin/utilisateurs/comptes/edit.html.twig', [
            'user' => $user,
            'form' => $form->createView(),
            'title' => 'Editer un mon compte',
            'active' => 'users.comptes.edit',
        ]);
    }

    public function periodeProformaSearchForm(Request $request): Response
    {
        //Formulaire de génération de facture par période
        $search = new PeriodeProformaSearch();
        $form = $this->createForm(ProformaPeriodeType::class, $search);
        $form->handleRequest($request);
        return $this->render('dashboard/includes/periodeProformaSearchForm.html.twig', [
            'form_periode' => $form->createView(),
        ]);
    }

    public function periodeFactureSearchForm(Request $request): Response
    {
        //Formulaire de génération de facture par période
        $search = new PeriodeProformaSearch();
        $form = $this->createForm(ProformaPeriodeType::class, $search);
        $form->handleRequest($request);
        return $this->render('dashboard/includes/periodeFactureSearchForm.html.twig', [
            'form_periode' => $form->createView(),
        ]);
    }
}
