<?php

namespace App\Controller\Admin;

use App\Entity\Departements;
use App\Form\DepartementsType;
use App\Managers\Managers;
use App\Repository\DepartementsRepository;
use App\Services\Helpers\FlashServiceInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Routing\Requirement\Requirement;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[Route('/dashboard/departements')]
#[IsGranted(new Expression('is_granted("ROLE_SUPER_ADMIN")'))]
class AdminDepartementsController extends AbstractController
{
    public function __construct(
        private readonly Managers              $manager,
        private readonly FlashServiceInterface $flash,
    )
    {
    }

    #[Route('/', name: "admin.departements.index", methods: ['GET', 'POST'])]
    public function index(Request $request, DepartementsRepository $departementsRepository): Response
    {
        $departement = new Departements();
        $form = $this->createForm(DepartementsType::class, $departement);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->manager->setEntity($departement, 'new');
            $this->flash->success("Enrégistrement effectué avec succès.");
            return $this->redirectToRoute('admin.departements.index');
        }
        return $this->render('admin/departements/index.html.twig', [
            'departement' => $departement,
            'form' => $form->createView(),
            'departements' => $departementsRepository->findAll(),
            'title' => 'Liste des départements',
            'libelle_ajouter' => 'Nouveau département',
            'active' => 'admin.departements.index',
        ]);
    }

    #[Route('/new', name: 'admin.departements.new', methods: ['GET', 'POST'])]
    public function new(Request $request): Response
    {
        $departement = new Departements();
        $form = $this->createForm(DepartementsType::class, $departement);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->manager->setEntity($departement, 'new');
            $this->flash->success("Enrégistrement effectué avec succès.");
            return $this->redirectToRoute('admin.departements.index');
        }

        return $this->render('admin/departements/new.html.twig', [
            'departement' => $departement,
            'form' => $form->createView(),
            'title' => 'Liste des départements',
            'libelle_liste' => 'Liste des départements',
            'libelle_ajouter' => 'Nouveau départements',
            'active' => 'admin.departements.index',
        ]);
    }

    #[Route('/{id}/edit', name: 'admin.departements.edit', requirements: ['id' => Requirement::DIGITS], methods: ['GET', 'POST'])]
    public function edit(Request $request, Departements $departement): Response
    {
        $form = $this->createForm(DepartementsType::class, $departement);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->manager->setEntity($departement, 'edit');
            $this->flash->success("Modification effectuée avec succès.");
            return $this->redirectToRoute('admin.departements.index', [
                'id' => $departement->getId(),
            ]);
        }

        return $this->render('admin/departements/edit.html.twig', [
            'departement' => $departement,
            'form' => $form->createView(),
            'title' => 'Editer un département',
            'libelle_ajouter' => 'Nouveau département',
            'libelle_liste' => 'Liste des départements',
            'active' => 'admin.departements.edit',
        ]);
    }

    #[Route('/{id}', name: 'admin.departements.delete', requirements: ['id' => Requirement::DIGITS], methods: ['DELETE'])]
    public function delete(Request $request, Departements $departement): Response
    {
        if ($this->isCsrfTokenValid('delete' . $departement->getId(), $request->request->get('_token'))) {
            $this->manager->setEntity($departement, 'delete');
            $this->flash->success("Suppression effectuée avec succès.");
        }

        return $this->redirectToRoute('admin.departements.index');
    }
}
