<?php

namespace App\Entity;

use App\Entity\Common\DatesTrait;
use App\Entity\Common\IdTrait;
use App\Repository\DepartementsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

#[ORM\Entity(repositoryClass: DepartementsRepository::class)]
#[ORM\HasLifecycleCallbacks]
#[UniqueEntity(fields: 'nomdepartement')]
class Departements
{
    use DatesTrait;
    use IdTrait;

    #[ORM\Column(type: 'string', length: 255, nullable: false)]
    #[Assert\NotBlank]
    private ?string $nomdepartement = null;

    #[ORM\Column(type: 'string', length: 255, nullable: false)]
    #[Assert\NotBlank]
    private ?string $responsable = null;

    #[ORM\Column(type: 'string', length: 255, nullable: true)]
    private ?string $telephone = null;

    #[ORM\OneToMany(targetEntity: Proformaparticuliers::class, mappedBy: 'departements')]
    private Collection $proformaparticuliers;

    public function __construct()
    {
        $this->proformaparticuliers = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNomdepartement(): ?string
    {
        return $this->nomdepartement;
    }

    public function setNomdepartement(string $nomdepartement): self
    {
        $this->nomdepartement = $nomdepartement;

        return $this;
    }

    public function getResponsable(): ?string
    {
        return $this->responsable;
    }

    public function setResponsable(string $responsable): self
    {
        $this->responsable = $responsable;

        return $this;
    }

    public function getTelephone(): ?string
    {
        return $this->telephone;
    }

    public function setTelephone(?string $telephone): self
    {
        $this->telephone = $telephone;

        return $this;
    }

    /**
     * @return Collection<int, Proformaparticuliers>
     */
    public function getProformaparticuliers(): Collection
    {
        return $this->proformaparticuliers;
    }

    public function addProformaparticulier(Proformaparticuliers $proformaparticulier): self
    {
        if (!$this->proformaparticuliers->contains($proformaparticulier)) {
            $this->proformaparticuliers[] = $proformaparticulier;
            $proformaparticulier->setDepartements($this);
        }

        return $this;
    }

    public function removeProformaparticulier(Proformaparticuliers $proformaparticulier): self
    {
        if ($this->proformaparticuliers->contains($proformaparticulier)) {
            $this->proformaparticuliers->removeElement($proformaparticulier);
            if ($proformaparticulier->getDepartements() === $this) {
                $proformaparticulier->setDepartements(null);
            }
        }

        return $this;
    }

    public function __toString()
    {
        return $this->nomdepartement . ' | ' . $this->responsable;
    }
}
