<?php

namespace App\Entity;

use App\Entity\Common\DatesTrait;
use App\Entity\Common\IdTrait;
use App\Repository\PaiementEntrepriseRepository;
use DateTimeImmutable;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

#[ORM\Entity(repositoryClass: PaiementEntrepriseRepository::class)]
#[ORM\HasLifecycleCallbacks]
class PaiementEntreprise
{

    use DatesTrait;
    use IdTrait;

    #[ORM\Column(type: Types::FLOAT, precision: 10, scale: 0, nullable: true, options: ['default' => 0])]
    private ?float $montant = 0;

    #[ORM\ManyToOne(targetEntity: Users::class)]
    private ?Users $user = null;

    #[ORM\Column(type: 'datetime_immutable', nullable: false)]
    #[Assert\NotBlank]
    private ?DateTimeImmutable $laDate;

    #[ORM\Column(type: 'text', nullable: false)]
    private ?string $numeroCheque = null;

    #[ORM\Column(type: 'text', nullable: true)]
    private ?string $numeroFacture = null;

    #[ORM\ManyToOne(targetEntity: Proformaentreprises::class, inversedBy: 'paiementEntreprises')]
    private ?Proformaentreprises $proformaentreprise = null;

    /**
     * @ORM\Column(type="string", length=500, nullable=true)
     */
    private $detail;

    public function __construct()
    {
        $this->laDate = new DateTimeImmutable();
    }

    public function getUser(): ?Users
    {
        return $this->user;
    }

    public function setUser(?Users $user): self
    {
        $this->user = $user;

        return $this;
    }

    public function getLaDate(): ?DateTimeImmutable
    {
        return $this->laDate;
    }

    public function setLaDate(?DateTimeImmutable $laDate): PaiementEntreprise
    {
        $this->laDate = $laDate;
        return $this;
    }

    public function getMontant(): ?float
    {
        return $this->montant;
    }

    public function setMontant(?float $montant): PaiementEntreprise
    {
        $this->montant = $montant;
        return $this;
    }

    public function getNumeroFacture(): ?string
    {
        return $this->numeroFacture;
    }

    public function setNumeroFacture(?string $numeroFacture): self
    {
        $this->numeroFacture = $numeroFacture;

        return $this;
    }

    public function getNumeroCheque(): ?string
    {
        return $this->numeroCheque;
    }

    public function setNumeroCheque(?string $numeroCheque): self
    {
        $this->numeroCheque = $numeroCheque;

        return $this;
    }

    public function getProformaentreprise(): ?Proformaentreprises
    {
        return $this->proformaentreprise;
    }

    public function setProformaentreprise(?Proformaentreprises $proformaentreprise): self
    {
        $this->proformaentreprise = $proformaentreprise;

        return $this;
    }

    public function getDetail(): ?string
    {
        return $this->detail;
    }

    public function setDetail(?string $detail): self
    {
        $this->detail = $detail;

        return $this;
    }

    public function __toString(): string
    {
        return $this->numeroFacture ?? '';
    }
}
