<?php

namespace App\Entity;

use App\Entity\Common\DatesTrait;
use App\Entity\Common\IdTrait;
use App\Repository\TypesclientsRepository;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

#[ORM\Entity(repositoryClass: TypesclientsRepository::class)]
#[ORM\HasLifecycleCallbacks]
#[UniqueEntity(fields: 'name')]
class Typesclients
{
    use DatesTrait;
    use IdTrait;

    #[ORM\Column(type: 'string', length: 255, nullable: false)]
    #[Assert\NotBlank]
    private ?string $name = null;

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function __toString()
    {
        return $this->name;
    }
}
