<?php

namespace App\Enum;

class UserRoles
{
    public const ROLES = [
        'ROLE_SUPER_ADMIN' => 'Super Administrateur',
        'ROLE_ENTREPRISE' => 'Entreprise',
        'ROLE_PARTICULIER' => 'Particulier',
    ];

    public const ROLE_SUPER_ADMIN = 'ROLE_SUPER_ADMIN';

    public const ROLE_ENTREPRISE = 'ROLE_ENTREPRISE';

    public const ROLE_PARTICULIER = 'ROLE_PARTICULIER';

    public static function getRolesUsers(string $key): ?string
    {
        return self::ROLES[$key] ?? null;
    }

    public static function isSuperAdmin(array $roles): bool
    {
        return in_array(self::ROLE_SUPER_ADMIN, $roles);
    }

    public static function isEntreprise(array $roles): bool
    {
        return in_array(self::ROLE_ENTREPRISE, $roles);
    }

    public static function isParticulier(array $roles): bool
    {
        return in_array(self::ROLE_PARTICULIER, $roles);
    }

    /**
     * @return array
     */
    public static function getRoles(): array
    {
        $choices = self::ROLES;
        $output = [];
        foreach ($choices as $k => $v) {
            $output[$v] = $k;
        }
        return $output;
    }
}