<?php

namespace App\Form\Entreprises\Searchs;

use App\Entity\Searchs\SearchEntrepriesProforma;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class SearchEntreprisesProformaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        /** @var SearchEntrepriesProforma $search */
        $search = $options['search'];
        $builder
            ->add('startAt', DateType::class, [
                'required' => false,
                'html5' => true,
                'input_format' => 'dd/MM/yyyy',
                'widget' => 'single_text',
                'label' => 'De',
                'data' => $search->startAt,
                'attr' => [
                    'class' => 'input-xs'
                ]
            ])->add('endAt', DateType::class, [
                'required' => false,
                'html5' => true,
                'input_format' => 'dd/MM/yyyy',
                'widget' => 'single_text',
                'label' => 'A',
                'data' => $search->endAt,
                'attr' => [
                    'class' => 'input-xs'
                ]
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => SearchEntrepriesProforma::class,
            'search' => null,
        ]);
    }
}
