<?php

namespace App\Form\Particuliers\Searchs;

use App\Entity\Searchs\SearchEntrepriesProforma;
use App\Entity\Searchs\SearchParticuliersPrestations;
use DateTime;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class SearchParticuliersPrestationsType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        /** @var SearchEntrepriesProforma $search */
        $search = $options['search'];

        $builder
            ->add('startAt', DateType::class, [
                'required' => false,
                'html5' => true,
                'input_format' => 'dd/MM/yyyy',
                'widget' => 'single_text',
                'label' => 'Date',
                'data' => $search->startAt ?? new DateTime(),
                'attr' => [
                    'class' => 'input-xs'
                ]
            ])->add('endAt', DateType::class, [
                'required' => false,
                'html5' => true,
                'input_format' => 'dd/MM/yyyy',
                'widget' => 'single_text',
                'label' => 'Date',
                'data' => $search->endAt ?? new DateTime(),
                'attr' => [
                    'class' => 'input-xs'
                ]
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => SearchParticuliersPrestations::class,
            'search' => null,
        ]);
    }
}
