<?php

namespace App\Services\Proforma;

use App\Entity\Parametres;
use App\Entity\Proformaentreprises;
use App\Repository\ParametresRepository;
use Spipu\Html2Pdf\Exception\Html2PdfException;
use Spipu\Html2Pdf\Html2Pdf;
use Symfony\Component\HttpFoundation\Response;
use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Error\SyntaxError;

readonly class EntrepriseProformaService
{
    public function __construct(
        private ParametresRepository $parametresRepository,
        private Environment          $environment,
    )
    {
    }

    /**
     * @throws RuntimeError
     * @throws SyntaxError
     * @throws LoaderError
     * @throws Html2PdfException
     */
    public function facture(Proformaentreprises $proforma, string $template): Response
    {
        $html = $this->environment->render($template, ['facture' => $proforma, 'societe' => $this->getSociete()]);
        $html2pdf = new Html2Pdf('P', 'A4', 'fr');
        $html2pdf->pdf->SetAuthor($this->getSociete()->getName());
        $html2pdf->pdf->SetTitle('Proforma_ ' . $proforma->getTitrefacture() . '_' . $proforma->getClientsentreprises()->getNom());
        $html2pdf->pdf->SetSubject('Proforma_ ' . $proforma->getTitrefacture() . '_' . $proforma->getClientsentreprises()->getNom());
        $html2pdf->pdf->SetKeywords('proformas');
        $html2pdf->pdf->SetDisplayMode('real');
        $html2pdf->writeHTML($html);
        $proformaTitre = str_replace(' ', '_', $proforma->getTitrefacture());
        $proformaName = str_replace(' ', '_', 'Proforma_' . $proformaTitre . '_' . $proforma->getClientsentreprises()->getNom());
        $html2pdf->output($proformaName . '.pdf');

        $response = new Response();

        $response->headers->set('Content-type', 'application/pdf');
        return $response;
    }

    private function getSociete(): Parametres
    {
        return $this->parametresRepository->find(1);
    }
}