<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* particuliers/bilans/index.html.twig */
class __TwigTemplate_765b5858a49b6460bbec6d3321545c17 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'title' => [$this, 'block_title'],
            'body' => [$this, 'block_body'],
            'javascripts' => [$this, 'block_javascripts'],
        ];
    }

    protected function doGetParent(array $context): bool|string|Template|TemplateWrapper
    {
        // line 1
        return "base.html.twig";
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $this->parent = $this->loadTemplate("base.html.twig", "particuliers/bilans/index.html.twig", 1);
        yield from $this->parent->unwrap()->yield($context, array_merge($this->blocks, $blocks));
    }

    // line 3
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["parametres"] ?? null), "structure", [], "any", false, false, false, 3), "name", [], "any", false, false, false, 3)) ? (CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["parametres"] ?? null), "structure", [], "any", false, false, false, 3), "name", [], "any", false, false, false, 3)) : (($context["company_name"] ?? null))), "html", null, true);
        yield " | Tableau de board ";
        yield from [];
    }

    // line 5
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_body(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 6
        yield "    <div class=\"row\">
        <div class=\"col-md-12\">
            <div class=\"panel panel-flat\">
                <div class=\"panel-heading\">
                    <h5 class=\"panel-title\">Trouver une facture pour une période donnée</h5>
                    <p><span class=\"imgChargement\">Chargement en cours...</span></p>
                    <div class=\"heading-elements\">
                        <ul class=\"icons-list\">
                            <li><a data-action=\"collapse\"></a></li>
                            <li><a data-action=\"close\"></a></li>
                        </ul>
                    </div>
                </div>

                <div class=\"panel-body\">
                    <div class=\"alert alert-warning\">
                        Note: Les éléments du bilan sont classés par
                        date de paiement
                    </div>

                    <!-- Nav tabs -->
                    <ul class=\"nav nav-tabs\" role=\"tablist\">
                        <li role=\"presentation\" class=\"active\">
                            <a href=\"#journalier\" aria-controls=\"journalier\" role=\"tab\" data-toggle=\"tab\">
                                Bilan journalier
                            </a>
                        </li>
                        ";
        // line 34
        yield "                        <li role=\"presentation\">
                            <a href=\"#mensuel\" aria-controls=\"mensuel\" role=\"tab\" data-toggle=\"tab\">
                                Bilan mensuel
                            </a>
                        </li>
                        <li role=\"presentation\">
                            <a href=\"#annuel\" aria-controls=\"annuel\" role=\"tab\" data-toggle=\"tab\">
                                Bilan Annuel
                            </a>
                        </li>
                        <li role=\"presentation\">
                            <a href=\"#parEmployer\" aria-controls=\"parEmployer\" role=\"tab\" data-toggle=\"tab\">
                                Bilan par personne
                            </a>
                        </li>
                        ";
        // line 50
        yield "                    </ul>

                    <!-- Tab panes -->
                    <div class=\"tab-content\">
                        <div role=\"tabpanel\" class=\"tab-pane active\" id=\"journalier\">
                            <div>
                                <form id=\"formJournalier\">
                                    <div class=\"form-group\">
                                        <div class=\"col-md-3\">
                                            <input type=\"text\" name=\"laDate\"
                                                   class=\"input-xs daterange-single form-control\"/>
                                        </div>
                                        <div class=\"col-md-2\">
                                            <span id=\"actualiserBilanJournalier\" class=\"btn btn-primary btn-xs\">
                                                <i class=\"icon-printer text-size-base\"></i>
                                            </span>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <br/>
                            <br/>
                            <div>
                                <table class=\"table table-xxs table-hover table-striped table-condensed datatable-basi\">
                                    <thead>
                                    <tr>
                                        <th>Clients</th>
                                        <th>N° Proforma</th>
                                        <th>Date paiement</th>
                                        <th class=\"text-center\">Montant</th>
                                    </tr>
                                    </thead>
                                    <tbody id=\"resultatBilanJournalier\"></tbody>
                                </table>
                            </div>
                        </div>

                        <div role=\"tabpanel\" class=\"tab-pane\" id=\"mensuel\">
                            <form id=\"formMensuel\">
                                <div class=\"form-group\">
                                    <div class=\"col-md-7\">
                                        <div class=\"col-md-3\">
                                            <select class=\"form-control\" id=\"anneeMensuel\" name=\"anneeMensuel\">
                                                ";
        // line 93
        $context['_parent'] = $context;
        $context['_seq'] = CoreExtension::ensureTraversable(Twig\Extension\CoreExtension::reverse($this->env->getCharset(), ($context["anneeIntervalle"] ?? null)));
        foreach ($context['_seq'] as $context["_key"] => $context["annee"]) {
            // line 94
            yield "                                                    <option value=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($context["annee"], "html", null, true);
            yield "\">";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($context["annee"], "html", null, true);
            yield "</option>
                                                ";
        }
        $_parent = $context['_parent'];
        unset($context['_seq'], $context['_key'], $context['annee'], $context['_parent']);
        $context = array_intersect_key($context, $_parent) + $_parent;
        // line 96
        yield "                                            </select>
                                        </div>
                                        <div class=\"col-md-3\">
                                            <select class=\"form-control\" id=\"moisMensuel\" name=\"moisMensuel\">
                                                ";
        // line 100
        $context['_parent'] = $context;
        $context['_seq'] = CoreExtension::ensureTraversable(($context["moisIntervalle"] ?? null));
        foreach ($context['_seq'] as $context["chiffre"] => $context["lettre"]) {
            // line 101
            yield "                                                    ";
            if (($context["chiffre"] == ($context["moisEnCours"] ?? null))) {
                // line 102
                yield "                                                        <option value=\"";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($context["chiffre"], "html", null, true);
                yield "\" selected>";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($context["lettre"], "html", null, true);
                yield "</option>
                                                    ";
            } else {
                // line 104
                yield "                                                        <option value=\"";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($context["chiffre"], "html", null, true);
                yield "\">";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($context["lettre"], "html", null, true);
                yield "</option>
                                                    ";
            }
            // line 106
            yield "                                                ";
        }
        $_parent = $context['_parent'];
        unset($context['_seq'], $context['chiffre'], $context['lettre'], $context['_parent']);
        $context = array_intersect_key($context, $_parent) + $_parent;
        // line 107
        yield "
                                            </select>
                                        </div>
                                        <div class=\"col-md-2\">
                                            <span id=\"actualiserBilanMensuel\" class=\"btn btn-primary btn-xs\">
                                                <i class=\"icon-printer text-size-base\"></i>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <br/>
                            <br/>
                            <table class=\"table table-xxs table-hover table-striped table-condensed datatable-basic\">
                                <thead>
                                <tr>
                                    <th>Clients</th>
                                    <th>N° Proforma</th>
                                    <th>Date de paiement</th>
                                    <th class=\"text-center\">Montant</th>
                                </tr>
                                </thead>
                                <tbody id=\"resultatBilanMensuel\"></tbody>
                            </table>
                        </div>
                        <div role=\"tabpanel\" class=\"tab-pane\" id=\"annuel\">
                            <form id=\"formAnnuel\">
                                <div class=\"form-group\">
                                    <div class=\"col-md-2\">
                                        <select class=\"form-control\" id=\"anneeAnnuel\" name=\"anneeAnnuel\">
                                            ";
        // line 137
        $context['_parent'] = $context;
        $context['_seq'] = CoreExtension::ensureTraversable(Twig\Extension\CoreExtension::reverse($this->env->getCharset(), ($context["anneeIntervalle"] ?? null)));
        foreach ($context['_seq'] as $context["_key"] => $context["annee"]) {
            // line 138
            yield "                                                <option value=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($context["annee"], "html", null, true);
            yield "\">";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($context["annee"], "html", null, true);
            yield "</option>
                                            ";
        }
        $_parent = $context['_parent'];
        unset($context['_seq'], $context['_key'], $context['annee'], $context['_parent']);
        $context = array_intersect_key($context, $_parent) + $_parent;
        // line 140
        yield "                                        </select>
                                    </div>

                                    <div class=\"col-md-2\">
                                        <span id=\"actualiserBilanAnnuel\" class=\"btn btn-primary btn-xs\">
                                            <i class=\"icon-printer text-size-base\"></i>
                                        </span>
                                    </div>
                                </div>
                            </form>
                            <br/>
                            <br/>
                            <div>
                                <table class=\"table table-xxs table-hover table-striped table-condensed datatable-basic\">
                                    <thead>
                                    <tr>
                                        <th>Clients</th>
                                        <th>N° Proforma</th>
                                        <th>Date de paiement</th>
                                        <th class=\"text-center\">Montant</th>
                                    </tr>
                                    </thead>
                                    <tbody id=\"resultatBilanAnnuel\"></tbody>
                                </table>
                            </div>
                        </div>
                        <div role=\"tabpanel\" class=\"tab-pane\" id=\"parEmployer\">
                            <form id=\"formParEmployer\">
                                <div class=\"form-group\">
                                    <div class=\"col-md-2\">
                                        <input type=\"text\" name=\"dateDebut\"
                                               class=\"input-xs daterange-single form-control\"/>
                                    </div>
                                    <div class=\"col-md-2\">
                                        <input type=\"text\" name=\"dateFin\"
                                               class=\"input-xs daterange-single form-control\"/>
                                    </div>
                                    <div class=\"col-md-4\">
                                        <input type=\"text\" name=\"client\" class=\"input-xs form-control\"/>
                                    </div>

                                    <div class=\"col-md-2\">
                                        <span id=\"actualiserBilanParEmployer\" class=\"btn btn-primary btn-xs\">
                                            <i class=\"icon-printer text-size-base\"></i>
                                        </span>
                                    </div>
                                </div>
                            </form>
                            <br/>
                            <br/>
                            <div>
                                <table class=\"table table-xxs table-hover table-striped table-condensed datatable-basi\">
                                    <thead>
                                    <tr>
                                        <th>Clients</th>
                                        <th class=\"text-center\">Nombre prestation</th>
                                        <th class=\"text-center\">Montant</th>
                                    </tr>
                                    </thead>
                                    <tbody id=\"resultatBilanParEmployer\"></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    ";
        // line 209
        if ((($context["proformas"] ?? null) != 0)) {
            // line 210
            yield "        <!-- Dashboard content -->
        <div class=\"row\">
            <div class=\"panel panel-flat\">
                <div class=\"panel-heading\">
                    <h5 class=\"panel-title\">Liste des proformas trouvéés</h5>
                    <div class=\"heading-elements\">
                        <ul class=\"icons-list\">
                            <li><a data-action=\"collapse\"></a></li>
                            <li><a data-action=\"close\"></a></li>
                        </ul>
                    </div>
                </div>

                <div class=\"panel-body\">
                    <table class=\"table table-xxs table-hover table-striped table-condensed datatable-basic\">
                        <thead>
                        <tr>
                            <th>Clients</th>
                            <th>N° Proforma</th>
                            <th>Date</th>
                            <th>Etat facture</th>
                            <th>Etat paiement</th>
                            ";
            // line 232
            if (CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["app"] ?? null), "user", [], "any", false, false, false, 232), "superAdmin", [], "any", false, false, false, 232)) {
                // line 233
                yield "                                <th>Statut</th>
                            ";
            }
            // line 235
            yield "                            <th class=\"text-center\">Actions</th>
                        </tr>
                        </thead>
                        <tbody>
                        ";
            // line 239
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable(($context["proformas"] ?? null));
            $context['_iterated'] = false;
            foreach ($context['_seq'] as $context["_key"] => $context["proformaparticulier"]) {
                // line 240
                yield "                            <tr>
                                <td width=\"200\">
                                    <a href=\"";
                // line 242
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("clientsentreprises.show", ["id" => CoreExtension::getAttribute($this->env, $this->source, $context["proformaparticulier"], "id", [], "any", false, false, false, 242)]), "html", null, true);
                yield "\">
                                        ";
                // line 243
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["proformaparticulier"], "nom", [], "any", false, false, false, 243), "html", null, true);
                yield "
                                    </a>
                                </td>
                                <td><a href=\"javascript:\">";
                // line 246
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["proformaparticulier"], "numerolabel", [], "any", false, false, false, 246), "html", null, true);
                yield "</a></td>
                                <td>";
                // line 247
                yield ((CoreExtension::getAttribute($this->env, $this->source, $context["proformaparticulier"], "datefacture", [], "any", false, false, false, 247)) ? ($this->env->getRuntime('Symfony\UX\TwigComponent\Twig\ComponentRuntime')->render("DateComponent", ["date" => CoreExtension::getAttribute($this->env, $this->source, $context["proformaparticulier"], "datefacture", [], "any", false, false, false, 247)])) : ("Aucune date"));
                yield "</td>
                                <td>
                                    ";
                // line 249
                if ((CoreExtension::getAttribute($this->env, $this->source, $context["proformaparticulier"], "statutproforma", [], "any", false, false, false, 249) == 0)) {
                    // line 250
                    yield "                                        <span class=\"label label-danger\">";
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["proformaparticulier"], "etatProforma", [], "any", false, false, false, 250), "html", null, true);
                    yield "</span>
                                    ";
                } elseif ((CoreExtension::getAttribute($this->env, $this->source,                 // line 251
$context["proformaparticulier"], "statutproforma", [], "any", false, false, false, 251) == 1)) {
                    // line 252
                    yield "                                        <span class=\"label label-warning\">";
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["proformaparticulier"], "etatProforma", [], "any", false, false, false, 252), "html", null, true);
                    yield "</span>
                                    ";
                } else {
                    // line 254
                    yield "                                        <span class=\"label label-success\">";
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["proformaparticulier"], "etatProforma", [], "any", false, false, false, 254), "html", null, true);
                    yield "</span>
                                    ";
                }
                // line 256
                yield "                                </td>
                                <td>
                                    ";
                // line 258
                if ((CoreExtension::getAttribute($this->env, $this->source, $context["proformaparticulier"], "etat", [], "any", false, false, false, 258) == 2)) {
                    // line 259
                    yield "                                        <span class=\"label label-success\">";
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["proformaparticulier"], "etatPaiement", [], "any", false, false, false, 259), "html", null, true);
                    yield "</span>
                                    ";
                } elseif ((CoreExtension::getAttribute($this->env, $this->source,                 // line 260
$context["proformaparticulier"], "etat", [], "any", false, false, false, 260) == 1)) {
                    // line 261
                    yield "                                        <span class=\"label label-warning\">";
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["proformaparticulier"], "etatPaiement", [], "any", false, false, false, 261), "html", null, true);
                    yield "</span>
                                    ";
                } else {
                    // line 263
                    yield "                                        <span class=\"label label-danger\">";
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["proformaparticulier"], "etatPaiement", [], "any", false, false, false, 263), "html", null, true);
                    yield "</span>
                                    ";
                }
                // line 265
                yield "                                </td>
                                ";
                // line 266
                if (CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["app"] ?? null), "user", [], "any", false, false, false, 266), "superAdmin", [], "any", false, false, false, 266)) {
                    // line 267
                    yield "                                    <td>
                                        ";
                    // line 268
                    if ((CoreExtension::getAttribute($this->env, $this->source, $context["proformaparticulier"], "statut", [], "any", false, false, false, 268) == 0)) {
                        // line 269
                        yield "                                            <span class=\"label label-danger\">Non vu</span>
                                        ";
                    } else {
                        // line 271
                        yield "                                            <span class=\"label label-success\"> Déjà vu</span>
                                        ";
                    }
                    // line 273
                    yield "                                    </td>
                                ";
                }
                // line 275
                yield "                                <td class=\"text-center\">
                                    <ul class=\"icons-list\">
                                        <li class=\"dropdown\">
                                            <a href=\"#\" class=\"dropdown-toggle\" data-toggle=\"dropdown\">
                                                <i class=\"icon-menu9\"></i>
                                            </a>

                                            <ul class=\"dropdown-menu dropdown-menu-right\">
                                                <li>
                                                    <a href=\"";
                // line 284
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("proformaparticuliers.show", ["id" => CoreExtension::getAttribute($this->env, $this->source, $context["proformaparticulier"], "id", [], "any", false, false, false, 284)]), "html", null, true);
                yield "\">
                                                        <i class=\"icon-eye-plus\"></i> Voir les détails
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href=\"";
                // line 289
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("proformaparticuliers.edit", ["id" => CoreExtension::getAttribute($this->env, $this->source, $context["proformaparticulier"], "id", [], "any", false, false, false, 289)]), "html", null, true);
                yield "\">
                                                        <i class=\"icon-pencil\"></i> Modifier
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href=\"";
                // line 294
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("proformaparticulier.pdf", ["id" => CoreExtension::getAttribute($this->env, $this->source, $context["proformaparticulier"], "id", [], "any", false, false, false, 294)]), "html", null, true);
                yield "\">
                                                        <i class=\"icon-printer\"></i> Imprimer
                                                    </a>
                                                </li>
                                                <li class=\"divider\"></li>
                                                ";
                // line 306
                yield "                                            </ul>
                                        </li>
                                    </ul>
                                </td>
                            </tr>
                        ";
                $context['_iterated'] = true;
            }
            if (!$context['_iterated']) {
                // line 312
                yield "                            <tr>
                                <td colspan=\"7\" class=\"text-center\">
                                    <span class=\"text-muted\">Aucune facture trouvée</span>
                                </td>
                            </tr>
                        ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['proformaparticulier'], $context['_parent'], $context['_iterated']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 318
            yield "                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <!-- /dashboard content -->
    ";
        }
        yield from [];
    }

    // line 328
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_javascripts(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 329
        yield "    ";
        yield from $this->yieldParentBlock("javascripts", $context, $blocks);
        yield "
    <script type=\"text/javascript\">
        document.addEventListener(\"DOMContentLoaded\", function () {
            const actualiserBilanMensuel = document.getElementById('actualiserBilanMensuel');
            const formMensuel = document.getElementById('formMensuel');
            const formAnnuel = document.getElementById('formAnnuel');
            const actualiserBilanAnnuel = document.getElementById('actualiserBilanAnnuel');
            const imgChargement = document.querySelector('.imgChargement');
            const actualiserBilanJournalier = document.getElementById('actualiserBilanJournalier');
            const formJournalier = document.getElementById('formJournalier');
            const formParEmployer = document.getElementById('formParEmployer');
            const actualiserBilanParEmployer = document.getElementById('actualiserBilanParEmployer');

            actualiserBilanJournalierFunc();
            actualiserBilanMensuelFunc();
            actualiserBilanAnnuelFunc();
            actualiserBilanParEmployerFunc();

            actualiserBilanJournalier.addEventListener(\"click\", actualiserBilanJournalierFunc);
            actualiserBilanMensuel.addEventListener(\"click\", actualiserBilanMensuelFunc);
            actualiserBilanAnnuel.addEventListener(\"click\", actualiserBilanAnnuelFunc);
            actualiserBilanParEmployer.addEventListener(\"click\", actualiserBilanParEmployerFunc);

            function actualiserBilanJournalierFunc() {
                imgChargement.style.display = 'inline-block';

                fetch(\"";
        // line 355
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("proformaparticuliers.periode.journalier");
        yield "\", {
                    method: \"POST\",
                    body: new URLSearchParams(new FormData(formJournalier))
                })
                    .then(response => response.text())
                    .then(result => {
                        document.getElementById('resultatBilanJournalier').innerHTML = result;
                        imgChargement.style.display = 'none';
                    })
                    .catch(error => {
                        console.error('Erreur:', error);
                        imgChargement.style.display = 'none';
                    });
            }

            function actualiserBilanMensuelFunc() {
                imgChargement.style.display = 'inline-block';

                fetch(\"";
        // line 373
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("proformaparticuliers.periode.mensuel");
        yield "\", {
                    method: \"POST\",
                    body: new URLSearchParams(new FormData(formMensuel))
                })
                    .then(response => response.text())
                    .then(result => {
                        document.getElementById('resultatBilanMensuel').innerHTML = result;
                        imgChargement.style.display = 'none';
                    })
                    .catch(error => {
                        console.error('Erreur:', error);
                        imgChargement.style.display = 'none';
                    });
            }

            function actualiserBilanAnnuelFunc() {
                imgChargement.style.display = 'inline-block';

                fetch(\"";
        // line 391
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("proformaparticuliers.periode.annuel");
        yield "\", {
                    method: \"POST\",
                    body: new URLSearchParams(new FormData(formAnnuel))
                })
                    .then(response => response.text())
                    .then(result => {
                        document.getElementById('resultatBilanAnnuel').innerHTML = result;
                        imgChargement.style.display = 'none';
                    })
                    .catch(error => {
                        console.error('Erreur:', error);
                        imgChargement.style.display = 'none';
                    });
            }

            function actualiserBilanParEmployerFunc() {
                imgChargement.style.display = 'inline-block';

                fetch(\"";
        // line 409
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("proformaparticuliers.periode.paremployer");
        yield "\", {
                    method: \"POST\",
                    body: new URLSearchParams(new FormData(formParEmployer))
                })
                    .then(response => response.text())
                    .then(result => {
                        document.getElementById('resultatBilanParEmployer').innerHTML = result;
                        imgChargement.style.display = 'none';
                    })
                    .catch(error => {
                        console.error('Erreur:', error);
                        imgChargement.style.display = 'none';
                    });
            }
        });

    </script>
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "particuliers/bilans/index.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  633 => 409,  612 => 391,  591 => 373,  570 => 355,  540 => 329,  533 => 328,  521 => 318,  510 => 312,  500 => 306,  492 => 294,  484 => 289,  476 => 284,  465 => 275,  461 => 273,  457 => 271,  453 => 269,  451 => 268,  448 => 267,  446 => 266,  443 => 265,  437 => 263,  431 => 261,  429 => 260,  424 => 259,  422 => 258,  418 => 256,  412 => 254,  406 => 252,  404 => 251,  399 => 250,  397 => 249,  392 => 247,  388 => 246,  382 => 243,  378 => 242,  374 => 240,  369 => 239,  363 => 235,  359 => 233,  357 => 232,  333 => 210,  331 => 209,  260 => 140,  249 => 138,  245 => 137,  213 => 107,  207 => 106,  199 => 104,  191 => 102,  188 => 101,  184 => 100,  178 => 96,  167 => 94,  163 => 93,  118 => 50,  101 => 34,  72 => 6,  65 => 5,  53 => 3,  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "particuliers/bilans/index.html.twig", "/home/usimeca/public_html/gestion/templates/particuliers/bilans/index.html.twig");
    }
}
