<?php

namespace App\Controller\Admin;

use App\Entity\PeriodeProformaSearch;
use App\Form\Entreprises\ProformaPeriodeType;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[Route('/dashboard/logs')]
#[IsGranted(new Expression('is_granted("ROLE_SUPER_ADMIN")'))]
class LogsController extends AbstractController
{
    #[Route('/', name: "admin.logs", methods: ['GET'])]
    public function index(): Response
    {
        return $this->render('admin/logs/index.html.twig', [
            'title' => 'Tous les logs',
        ]);
    }

    public function periodeProformaSearchForm(Request $request): Response
    {
        //Formulaire de génération de facture par période
        $search = new PeriodeProformaSearch();
        $form = $this->createForm(ProformaPeriodeType::class, $search);
        $form->handleRequest($request);
        return $this->render('dashboard/includes/periodeProformaSearchForm.html.twig', [
            'form_periode' => $form->createView(),
        ]);
    }
}
