<?php

namespace App\Controller\Entreprises;

use App\Entity\PeriodeProformaSearch;
use App\Form\Entreprises\ProformaPeriodeType;
use App\Repository\PaiementEntrepriseRepository;
use App\Repository\ProformaentreprisesRepository;
use DateTime;
use Exception;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[Route('/dashboard/entreprise/facture/impression')]
#[IsGranted(new Expression('is_granted("ROLE_SUPER_ADMIN") or is_granted("ROLE_ENTREPRISE")'))]
class ImpressionEntreprisesController extends AbstractController
{
    public function __construct(
        private readonly ProformaentreprisesRepository $proformaentreprisesRepository,
        private readonly PaiementEntrepriseRepository  $paiementEntrepriseRepository,
    )
    {
    }

    #[Route('/periode', name: "bilan.facture", methods: ['GET'])]
    public function index(): Response
    {
        $proformas = null;
        $moisEnCours = date('m');
        $anneeEnCours = date('Y');
        $anneeIntervalle = array();

        for ($i = 2010; $i <= $anneeEnCours; $i++) {
            $anneeIntervalle[] = $i;
        }
        for ($i = 2010; $i <= date('Y'); $i++) {
            $anneeIntervalle[] = $i;
        }
        $moisIntervalle = [
            '01' => 'Janvier',
            '02' => 'Février',
            '03' => 'Mars',
            '04' => 'Avril',
            '05' => 'Mai',
            '06' => 'Juin',
            '07' => 'Juillet',
            '08' => 'Août',
            '09' => 'Septembre',
            '10' => 'Octobre',
            '11' => 'Novembre',
            '12' => 'Décembre',
        ];

        return $this->render('entreprises/bilans/index.html.twig', [
            'proformas' => $proformas,
            'anneeEnCours' => $anneeEnCours,
            'moisEnCours' => $moisEnCours,
            'anneeIntervalle' => $anneeIntervalle,
            'moisIntervalle' => $moisIntervalle,
            'title' => 'Imprimer une facture pour une période donnée'
        ]);
    }

    /**
     * @throws Exception
     */
    #[Route('/search/periode', name: "proformaentreprise.periode.pdf", methods: ['GET', 'POST'])]
    public function proformaPeriodeListe(Request $request): Response
    {
        $anneeIntervalle = array();
        $search = new PeriodeProformaSearch();
        $form_periode = $this->createForm(ProformaPeriodeType::class, $search);
        $form_periode->handleRequest($request);
        if ($form_periode->isSubmitted() && $form_periode->isValid()) {
            $datedebut = new DateTime($this->convertDateMysql($form_periode->get('datedebut')->getData()) . ' 00:00:00');
            $datefin = new DateTime($this->convertDateMysql($form_periode->get('datefin')->getData()) . ' 00:00:00');
            $proformas = $this->proformaentreprisesRepository->getProformaByPeriode($datedebut, $datefin);
        } else {
            $proformas = null;
        }

        return $this->render('entreprises/bilans/index.html.twig', [
            'form_periode' => $form_periode->createView(),
            'proformas' => $proformas,
            'title' => 'Imprimer une facture pour une période donnée'
        ]);

    }

    private function convertDateMysql($date): string
    {
        $datebenutexplode = explode('/', $date);
        return $datebenutexplode[2] . '/' . $datebenutexplode[1] . '/' . $datebenutexplode[0];
    }

    /**
     * @throws Exception
     */
    #[Route('/search/periode-mensuel', name: "proformaentreprise.periode.pdf.mensuel", methods: ['GET', 'POST'])]
    public function proformaPeriodeListeMensuel(Request $request): Response
    {
        $nombreDeJour = [
            '01' => 31,
            '02' => 29,
            '03' => 31,
            '04' => 30,
            '05' => 31,
            '06' => 30,
            '07' => 31,
            '08' => 31,
            '09' => 30,
            '10' => 31,
            '11' => 30,
            '12' => 31
        ];

        $anneeMensuel = $request->request->get('anneeMensuel');
        $moisMensuel = $request->request->get('moisMensuel');
        $dateDebut = new DateTime($anneeMensuel . '-' . $moisMensuel . '-01');
        $dateFin = new DateTime($anneeMensuel . '-' . $moisMensuel . '-' . $nombreDeJour[$moisMensuel]);
        $paiements = $this->paiementEntrepriseRepository->findPaiementByPeriode($dateDebut, $dateFin);

        return $this->render('entreprises/bilans/index_entreprise.html.twig', [
            'paiements' => $paiements
        ]);

    }

    /**
     * @throws Exception
     */
    #[Route('/search/periode-annuel', name: "proformaentreprise.periode.pdf.annuel", methods: ['GET', 'POST'])]
    public function proformaPeriodeListeAnnuel(Request $request): Response
    {
        $anneeAnnuel = $request->request->get('anneeAnnuel');
        $dateDebut = new DateTime($anneeAnnuel . '-01-01');
        $dateFin = new DateTime($anneeAnnuel . '-12-31');

        $paiements = $this->paiementEntrepriseRepository->findPaiementByPeriode($dateDebut, $dateFin);

        return $this->render('entreprises/bilans/index_entreprise.html.twig', [
            'paiements' => $paiements
        ]);

    }

    /**
     * @throws Exception
     */
    #[Route('/search/periode-by-employe', name: "proformaentreprise.periode.pdf.paremploye", methods: ['GET', 'POST'])]
    public function proformaPeriodeListeParEmploye(Request $request): Response
    {
        $dDebut = $request->request->get('dateDebut');
        $dFin = $request->request->get('dateFin');

        $dDebut = preg_replace("#(/)#", '-', $dDebut);
        $dFin = preg_replace("#(/)#", '-', $dFin);

        $dateDebut = new DateTime($dDebut);
        $dateDebut->setTime(0, 0);
        $dateFin = new DateTime($dFin);
        $dateFin->setTime(23, 59, 59);
        $paiements = $this->paiementEntrepriseRepository->findPaiementByPeriodeAndGroupUser($dateDebut, $dateFin);

        return $this->render('entreprises/bilans/index_entreprise.html.twig', [
            'paiements' => $paiements
        ]);
    }

}
