<?php

namespace App\Entity;

use App\Entity\Common\DatesTrait;
use App\Entity\Common\IdTrait;
use App\Repository\ProformaparticuliersRepository;
use DateTime;
use DateTimeInterface;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;
use Vich\UploaderBundle\Mapping\Annotation as Vich;

#[ORM\Entity(repositoryClass: ProformaparticuliersRepository::class)]
#[ORM\HasLifecycleCallbacks]
#[Vich\Uploadable]
#[UniqueEntity(fields: 'numero')]
class Proformaparticuliers
{
    use DatesTrait;
    use IdTrait;

    const ETATPAIEMENTS = [
        0 => 'Non payée',
        1 => 'Partielle',
        2 => 'Payée',
    ];

    const STATUTPROFORMA = [
        0 => 'Annuleé',
        1 => 'En attente de validation',
        2 => 'Validée',
    ];

    #[ORM\Column(type: 'string', length: 255, nullable: false)]
    private ?string $numero = null;

    #[ORM\Column(type: 'date', nullable: false)]
    #[Assert\NotBlank]
    private ?DateTimeInterface $datefacture = null;

    #[ORM\Column(type: 'string', length: 255, nullable: false)]
    private ?string $mois;

    #[ORM\Column(type: 'string', length: 255, nullable: false)]
    #[Assert\NotBlank]
    private ?string $titrefacture = null;

    #[ORM\Column(type: Types::FLOAT, precision: 10, scale: 0, nullable: true, options: ['default' => 0])]
    private ?float $totalht = 0;

    #[ORM\Column(type: Types::FLOAT, precision: 10, scale: 0, nullable: true, options: ['default' => 0])]
    private ?float $totalttc = 0;

    #[ORM\Column(type: 'text', nullable: false)]
    private ?string $montantlettre = null;

    #[ORM\Column(type: 'float', nullable: true)]
    private ?float $tva = 0;

    #[ORM\Column(type: 'array', nullable: false)]
    private array $produits = [];

    #[ORM\Column(type: 'boolean', nullable: true, options: ['default' => false])]
    private ?bool $valider = false;

    #[ORM\Column(type: 'boolean', nullable: true, options: ['default' => false])]
    private ?bool $annuler;

    #[ORM\Column(type: 'boolean', nullable: true, options: ['default' => false])]
    private ?bool $statut = false;

    #[ORM\Column(type: 'boolean', nullable: true, options: ['default' => false])]
    private ?bool $recupere;

    #[ORM\Column(type: 'text', nullable: false)]
    private ?string $mentionvalidite = null;

    #[ORM\Column(type: 'string', length: 30, nullable: false)]
    private ?string $numerolabelle = null;

    #[ORM\Column(type: 'integer', nullable: false)]
    private ?int $etat = 0;

    #[ORM\Column(type: 'datetime')]
    #[Assert\NotBlank]
    private ?DateTimeInterface $datecreation = null;

    #[ORM\Column(type: 'integer', nullable: false)]
    private ?int $statutproforma;

    #[ORM\Column(type: Types::FLOAT, precision: 10, scale: 0, nullable: true, options: ['default' => 0])]
    private ?float $montantpaye = 0;

    #[ORM\Column(type: Types::FLOAT, precision: 10, scale: 0, nullable: true, options: ['default' => 0])]
    private ?float $resteAPayer = 0;

    #[ORM\Column(type: 'string', length: 15, nullable: false)]
    private ?string $code = null;

    #[ORM\Column(type: 'string', length: 255, nullable: false)]
    private ?string $nom = null;

    #[ORM\Column(type: 'string', length: 255, nullable: false)]
    private ?string $telephone = null;

    #[ORM\Column(type: 'string', length: 255, nullable: true)]
    private ?string $adresse = null;

    #[ORM\Column(type: 'string', length: 255, nullable: true)]
    private ?string $email = null;

    #[ORM\Column(type: 'string', length: 255, nullable: false)]
    private ?string $codelabel = null;

    #[ORM\ManyToOne(targetEntity: Etatsreglements::class, inversedBy: 'proformaparticuliers')]
    private ?etatsreglements $modereglements = null;

    #[ORM\ManyToOne(targetEntity: Users::class, inversedBy: 'proformaparticuliers')]
    private ?Users $users = null;

    #[ORM\ManyToOne(targetEntity: Departements::class, inversedBy: 'proformaparticuliers')]
    private ?Departements $departements = null;

    public function __construct()
    {
        $this->datecreation = new DateTime('now');
        $this->statutproforma = 1;
        $this->mois = date('Y-m');
        $this->annuler = false;
        $this->recupere = true;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNumero(): ?string
    {
        return $this->numero;
    }

    public function setNumero(string $numero): self
    {
        $this->numero = $numero;

        return $this;
    }

    public function getDatefacture(): ?DateTimeInterface
    {
        return $this->datefacture;
    }

    public function setDatefacture(DateTimeInterface $datefacture): self
    {
        $this->datefacture = $datefacture;

        return $this;
    }

    public function getMois(): ?string
    {
        return $this->mois;
    }

    public function setMois(string $mois): self
    {
        $this->mois = $mois;

        return $this;
    }

    public function getTitrefacture(): ?string
    {
        return $this->titrefacture;
    }

    public function setTitrefacture(string $titrefacture): self
    {
        $this->titrefacture = $titrefacture;

        return $this;
    }

    public function getTotalht(): ?int
    {
        return $this->totalht;
    }

    public function setTotalht(int $totalht): self
    {
        $this->totalht = $totalht;

        return $this;
    }

    public function getTotalttc(): ?int
    {
        return $this->totalttc;
    }

    public function setTotalttc(int $totalttc): self
    {
        $this->totalttc = $totalttc;

        return $this;
    }

    public function getMontantlettre(): ?string
    {
        return $this->montantlettre;
    }

    public function setMontantlettre(string $montantlettre): self
    {
        $this->montantlettre = $montantlettre;

        return $this;
    }

    public function getTva(): ?int
    {
        return $this->tva;
    }

    public function setTva(?int $tva): self
    {
        $this->tva = $tva;

        return $this;
    }

    public function getProduits(): ?array
    {
        return $this->produits;
    }

    public function setProduits(array $produits): self
    {
        $this->produits = $produits;

        return $this;
    }

    public function getValider(): ?bool
    {
        return $this->valider;
    }

    public function setValider(bool $valider): self
    {
        $this->valider = $valider;

        return $this;
    }

    public function getRecupere(): ?bool
    {
        return $this->recupere;
    }

    public function setRecupere(bool $recupere): self
    {
        $this->recupere = $recupere;

        return $this;
    }

    public function getAnnuler(): ?bool
    {
        return $this->annuler;
    }

    public function setAnnuler(bool $annuler): self
    {
        $this->annuler = $annuler;

        return $this;
    }

    public function getStatut(): ?bool
    {
        return $this->statut;
    }

    public function setStatut(bool $statut): self
    {
        $this->statut = $statut;

        return $this;
    }

    public function getMentionvalidite(): ?string
    {
        return $this->mentionvalidite;
    }

    public function setMentionvalidite(string $mentionvalidite): self
    {
        $this->mentionvalidite = $mentionvalidite;

        return $this;
    }

    public function getNumerolabel(): ?string
    {
        return $this->numerolabelle;
    }

    public function setNumerolabel(string $numerolabel): self
    {
        $this->numerolabelle = $numerolabel;

        return $this;
    }

    public function getEtatPaiement(): string
    {
        return self::ETATPAIEMENTS[$this->etat];
    }

    public function getEtatProforma(): string
    {
        return self::STATUTPROFORMA[$this->statutproforma];
    }

    public function getEtat(): ?int
    {
        return $this->etat;
    }

    public function setEtat(int $etat): self
    {
        $this->etat = $etat;

        return $this;
    }

    public function getDatecreation(): ?DateTimeInterface
    {
        return $this->datecreation;
    }

    public function setDatecreation(DateTimeInterface $datecreation): self
    {
        $this->datecreation = $datecreation;

        return $this;
    }

    public function getModereglements(): ?etatsreglements
    {
        return $this->modereglements;
    }

    public function setModereglements(?etatsreglements $modereglements): self
    {
        $this->modereglements = $modereglements;

        return $this;
    }

    public function getUsers(): ?Users
    {
        return $this->users;
    }

    public function setUsers(?Users $users): self
    {
        $this->users = $users;

        return $this;
    }

    public function getStatutproforma(): ?int
    {
        return $this->statutproforma;
    }

    public function setStatutproforma(int $statutproforma): self
    {
        $this->statutproforma = $statutproforma;

        return $this;
    }

    public function getMontantpaye(): ?int
    {
        return $this->montantpaye;
    }

    public function setMontantpaye(?int $montantpaye): self
    {
        $this->montantpaye = $montantpaye;

        return $this;
    }

    public function getResteAPayer(): ?int
    {
        return $this->resteAPayer;
    }

    public function setResteAPayer(?int $resteAPayer): self
    {
        $this->resteAPayer = $resteAPayer;

        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->code = $code;

        return $this;
    }

    public function getNom(): ?string
    {
        return $this->nom;
    }

    public function setNom(string $nom): self
    {
        $this->nom = $nom;

        return $this;
    }

    public function getTelephone(): ?string
    {
        return $this->telephone;
    }

    public function setTelephone(string $telephone): self
    {
        $this->telephone = $telephone;

        return $this;
    }

    public function getAdresse(): ?string
    {
        return $this->adresse;
    }

    public function setAdresse(string $adresse): self
    {
        $this->adresse = $adresse;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(?string $email): self
    {
        $this->email = $email;

        return $this;
    }

    public function getCodelabel(): ?string
    {
        return $this->codelabel;
    }

    public function setCodelabel(string $codelabel): self
    {
        $this->codelabel = $codelabel;

        return $this;
    }

    public function getDepartements(): ?Departements
    {
        return $this->departements;
    }

    public function setDepartements(?Departements $departements): self
    {
        $this->departements = $departements;

        return $this;
    }

    /*#[ORM\PreUpdate]
    public function miseAJour(): void
    {
        $chiffreEnLettre = new ChiffreEnLettre;

        $montantlettre = strtoupper($chiffreEnLettre->Conversion($this->totalttc));
        $this->montantlettre = $montantlettre;

        $this->resteAPayer = $this->totalttc - $this->montantpaye;

    }*/

}
