<?php

namespace App\Form;

use App\Entity\ClientsSearch;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SearchType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ClientsSearchType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('q', SearchType::class, [
                'required' => false,
                'label' => false,
                'attr' => [
                    'placeholder' => 'rechercher entreprise/particulier',
                    'class' => 'form-control input-xs',
                    'autocomplete' => 'off',
                ],
            ])
            ->add('clienttype', ChoiceType::class, [
                'required' => false,
                'label' => false,
                'choices' => $this->getTypeClients(),
                'placeholder' => 'Sélectionnez un client',
                'attr' => [
                    'class' => 'form-control input-xs',
                ],
            ]);
    }

    /**
     * @return  array<string>
     */
    private function getTypeClients(): array
    {
        $choices = ClientsSearch::CLIENTTYPES;
        $output = [];
        foreach ($choices as $k => $v) {
            $output[$v] = $k;
        }
        return $output;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => ClientsSearch::class,
            'method' => 'get',
            'csrf_protection' => false,
        ]);
    }

    public function getBlockPrefix(): string
    {
        return '';
    }
}
