<?php

namespace App\Form;

use App\Entity\Mails;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Vich\UploaderBundle\Form\Type\VichFileType;

class MailsType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('objet', null, ['label' => 'Objet du mail', 'attr' => [
                'placeholder' => 'Objet du mail',
                'class' => 'input-xs',
            ]])
            ->add('email', EmailType::class, ['label' => 'Email du destinataire', 'attr' => [
                'placeholder' => 'Email du destinataire',
                'class' => 'input-xs',
            ]])
            ->add('message', null, ['label' => 'Votre message', 'attr' => [
                'placeholder' => 'Saisissez votre message',
                'class' => 'input-xs',
            ]])
            ->add('file', VichFileType::class, [
                'required' => false,
                'attr' => [
                    'class' => ''
                ],
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Mails::class,
        ]);
    }
}
