<?php

namespace App\Form;

use App\Entity\Notes;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Vich\UploaderBundle\Form\Type\VichFileType;

class NotesType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('title', null, ['label' => 'Titre de la note', 'attr' => [
                'placeholder' => 'Titre de la note',
                'class' => 'input-xs',
            ]])
            ->add('description', null, ['label' => 'Description de la note', 'attr' => [
                'placeholder' => 'Description de la note',
                'class' => 'input-xs',
            ]])
            ->add('color', null, ['label' => false, 'attr' => [
                'placeholder' => 'Couleur',
                'class' => 'input-xs colorpicker-palette-hide',
            ]])
            ->add('nomfichier', null, ['label' => 'Nom du fichier', 'attr' => [
                'placeholder' => 'Nom du fichier',
                'class' => 'input-xs',
            ]])
            ->add('file', VichFileType::class, [
                'required' => false,
                'attr' => [
                    'class' => ''
                ],
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Notes::class,
        ]);
    }
}
