<?php

namespace App\Form\Particuliers;

use App\Entity\Proformaparticuliers;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ProformaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('nom', null, ['label' => 'Nom et prenoms du client', 'attr' => [
                'placeholder' => 'Nom et prenoms du client',
                'class' => 'input-xs',
            ]])
            ->add('telephone', null, ['label' => 'Téléphone du client', 'attr' => [
                'placeholder' => 'Téléphone du client',
                'class' => 'input-xs',
            ]])
            ->add('adresse', null, ['label' => 'Adresse du client', 'attr' => [
                'placeholder' => 'Adresse du client',
                'class' => 'input-xs',
            ]])
            ->add('email', null, ['label' => 'Email du client', 'attr' => [
                'placeholder' => 'Email du client',
                'class' => 'input-xs',
            ]])
            ->add('titrefacture', null, ['label' => 'Titre', 'attr' => [
                'placeholder' => 'Titre de la facture',
                'class' => 'input-xs',
            ]])
            ->add('montantlettre', null, ['label' => 'Montant total en lettre', 'attr' => [
                'placeholder' => 'Montant total en lettre',
                'class' => 'input-xs',
            ]])
            ->add('mentionvalidite', TextareaType::class, [
                'label' => 'Mention de validité',
                'data' => 'Cette proforma n\'est valable que pour 30 jours à compter de la date d\'emission',
                'attr' => [
                    'placeholder' => 'Mention de validité',
                    'class' => 'input-xs',
                ]])
            ->add('etat', ChoiceType::class, [
                'choices' => $this->getChoices(),
                'label' => 'Etat de paiement',
                'placeholder' => 'Sélectionner un état de paiement',
                'attr' => ['class' => 'input-xs',],
            ])
            ->add('statut', ChoiceType::class, [
                'choices' => $this->getStatus(),
                'label' => 'Annuler la facture?',
                'placeholder' => 'Sélectionner un statut',
                'attr' => ['class' => 'input-xs',],
            ])
            ->add('modereglements', null, ['label' => 'Mode de règlement', 'placeholder' => 'Sélectionner un mode de règlement', 'attr' => [
                'class' => 'input-xs',
            ]])
            ->add('montantpaye', null, ['label' => 'Montant payé', 'attr' => [
                'placeholder' => 'Montant payé',
                'class' => 'input-xs',
                'min' => 0,
            ]]);
    }

    private function getChoices(): array
    {
        $choices = Proformaparticuliers::ETATPAIEMENTS;
        $output = [];
        foreach ($choices as $k => $v) {
            $output[$v] = $k;
        }
        return $output;
    }

    private function getStatus(): array
    {
        $choices = Proformaparticuliers::STATUTPROFORMA;
        $output = [];
        foreach ($choices as $k => $v) {
            $output[$v] = $k;
        }
        return $output;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Proformaparticuliers::class,
        ]);
    }
}
