<?php declare(strict_types=1);

namespace App\Services\Carts;

interface CartServiceInterface
{
    public function add(CartItem $item): void;

    public function getItems(): array;

    public function update(int $index, string $designation, int $quantity, float $price): void;

    public function updateItems(array $updatedItems): void;

    public function getTotalHorsTaxe(): float;

    public function getTotal(): float;

    public function tva(): int;

    public function discount(): int;

    public function calculateTax(int $taxRate): float;

    public function calculateDiscount(int $discountRate): float;

    public function remove(int $index): void;

    public function clear(): void;
}