<?php

namespace App\Controller;

use App\Entity\ClientsSearch;
use App\Entity\PeriodeProformaSearch;
use App\Entity\Users;
use App\Form\ClientsSearchType;
use App\Form\Entreprises\ProformaPeriodeType;
use App\Form\UsersComptesType;
use App\Managers\Managers;
use App\Repository\ClientsentreprisesRepository;
use App\Repository\ProformaentreprisesRepository;
use App\Repository\ProformaparticuliersRepository;
use App\Services\Helpers\FlashServiceInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Routing\Requirement\Requirement;

//#[IsGranted(new Expression('is_granted("ROLE_SUPER_ADMIN") or is_granted("ROLE_ENTREPRISE") or is_granted("ROLE_PARTICULIER")'))]
class AdminController extends AbstractController
{

    public function __construct(
        private readonly Managers                       $manager,
        private readonly FlashServiceInterface          $flash,
        private readonly ProformaentreprisesRepository  $proformaentreprisesRepository,
        private readonly ClientsentreprisesRepository   $clientsentreprisesRepository,
        private readonly ProformaparticuliersRepository $proformaparticuliersRepository,
    )
    {
    }

    #[Route('/', name: 'home')]
    public function index(): Response
    {

        //Entreprises
        $sommeTotalProformaentreprises = $this->proformaentreprisesRepository->findSumTotal();
        $clientsentreprises = $this->clientsentreprisesRepository->findAll();
        $proformaentreprises = $this->proformaentreprisesRepository->findAll();
        $proformaentreprisestoday = $this->proformaentreprisesRepository->findToday();
        $proformaentreprisesyesterday = $this->proformaentreprisesRepository->findYesterday();
        $proformaentreprisesvalider = $this->proformaentreprisesRepository->findBy(['valider' => true]);
        $proformaentreprisesinvalider = $this->proformaentreprisesRepository->findBy(['valider' => false]);
        //Particuliers
        $sommeTotalProformaparticuliers = $this->proformaparticuliersRepository->findSumTotal();
        $proformaparticuliers = $this->proformaparticuliersRepository->findAll();
        $proformaparticulierstoday = $this->proformaparticuliersRepository->findToday();
        $proformaparticuliersyesterday = $this->proformaparticuliersRepository->findYesterday();
        $proformaparticuliersvalider = $this->proformaparticuliersRepository->findBy(['valider' => true]);
        $proformaparticuliersinvalider = $this->proformaparticuliersRepository->findBy(['valider' => false]);

        return $this->render('dashboard/index.html.twig', [
            'sommeTotalProformaentreprises' => $sommeTotalProformaentreprises,
            'countclientsentreprises' => count($clientsentreprises),
            'countproformaentreprises' => count($proformaentreprises),
            'countproformaentreprisesvalider' => count($proformaentreprisesvalider),
            'countproformaentreprisesinvalider' => count($proformaentreprisesinvalider),
            'proformaentreprisestoday' => $proformaentreprisestoday,
            'proformaentreprisesyesterday' => $proformaentreprisesyesterday,
            'sommeTotalProformaparticuliers' => $sommeTotalProformaparticuliers,
            'countproformaparticuliers' => count($proformaparticuliers),
            'countproformaparticuliersvalider' => count($proformaparticuliersvalider),
            'countproformaparticuliersinvalider' => count($proformaparticuliersinvalider),
            'proformaparticulierstoday' => $proformaparticulierstoday,
            'proformaparticuliersyesterday' => $proformaparticuliersyesterday,
            'active' => 'home',
            'title' => 'Tableau de board',
        ]);
    }

    public function statistiquesParticuliers(): Response
    {
        //Particuliers
        $sommeTotalProformaparticuliers = $this->proformaparticuliersRepository->findSumTotal();
        $proformaparticuliers = $this->proformaparticuliersRepository->findAll();
        $proformaparticulierstoday = $this->proformaparticuliersRepository->findToday();
        $proformaparticuliersyesterday = $this->proformaparticuliersRepository->findYesterday();
        $facturesJournaliers = $this->proformaparticuliersRepository->findFacturesJournaliers();
        $facturesHebdomadaires = $this->proformaparticuliersRepository->findFacturesHebdomadaire();
        $facturesMensuels = $this->proformaparticuliersRepository->findFacturesMensuel();
        $proformaparticuliersvalider = $this->proformaparticuliersRepository->findBy(['valider' => true]);
        $proformaparticuliersinvalider = $this->proformaparticuliersRepository->findBy(['valider' => false]);
        //dd($facturesJournaliers, $facturesHebdomadaires, $facturesMensuels);
        return $this->render('dashboard/includes/particuliers_statistique.html.twig', [
            'sommeTotalProformaparticuliers' => $sommeTotalProformaparticuliers,
            'countproformaparticuliers' => count($proformaparticuliers),
            'countproformaparticuliersvalider' => count($proformaparticuliersvalider),
            'countproformaparticuliersinvalider' => count($proformaparticuliersinvalider),
            'proformaparticulierstoday' => $proformaparticulierstoday,
            'proformaparticuliersyesterday' => $proformaparticuliersyesterday,
            'facturejournaliers' => $facturesJournaliers,
            'facturesHebdomadaires' => $facturesHebdomadaires,
            'facturesMensuels' => $facturesMensuels,
        ]);
    }

    public function statistiquesEntreprises(): Response
    {
        //Entreprises
        $sommeTotalProformaentreprises = $this->proformaentreprisesRepository->findSumTotal();
        $clientsentreprises = $this->clientsentreprisesRepository->findAll();
        $proformaentreprises = $this->proformaentreprisesRepository->findAll();
        $proformaentreprisestoday = $this->proformaentreprisesRepository->findToday();
        $proformaentreprisesyesterday = $this->proformaentreprisesRepository->findYesterday();
        $proformaentreprisesvalider = $this->proformaentreprisesRepository->findBy(['valider' => true]);
        $proformaentreprisesinvalider = $this->proformaentreprisesRepository->findBy(['valider' => false]);

        return $this->render('dashboard/includes/entreprises_statistique.html.twig', [
            'sommeTotalProformaentreprises' => $sommeTotalProformaentreprises,
            'countclientsentreprises' => count($clientsentreprises),
            'countproformaentreprises' => count($proformaentreprises),
            'countproformaentreprisesvalider' => count($proformaentreprisesvalider),
            'countproformaentreprisesinvalider' => count($proformaentreprisesinvalider),
            'proformaentreprisestoday' => $proformaentreprisestoday,
            'proformaentreprisesyesterday' => $proformaentreprisesyesterday,
        ]);
    }

    #[Route('/users/compte/{id}/edit', name: 'users.comptes.edit', requirements: ['id' => Requirement::DIGITS], methods: ['GET', 'POST'])]
    public function editCompte(Request $request, Users $user): Response
    {
        $form = $this->createForm(UsersComptesType::class, $user);
        $form->handleRequest($request);
        if ($form->isSubmitted()) {
            $user->setUsername(strtolower($form->get('username')->getData()));
            $user->setEmail(strtolower($form->get('email')->getData()));
            $this->manager->setEntity($user, 'edit');
            $this->flash->success("Modification effectuée avec succès.");
            return $this->redirectToRoute('users.comptes.edit', [
                'id' => $user->getId(),
            ]);
        }

        return $this->render('admin/utilisateurs/comptes/edit.html.twig', [
            'user' => $user,
            'form' => $form->createView(),
            'title' => 'Editer un mon compte',
            'active' => 'users.comptes.edit',
        ]);
    }

    public function getCountNewsProformaAdd(): Response
    {
        $proformaentreprises = $this->proformaentreprisesRepository->findBy(['statut' => false]);
        $proformaparticuliers = $this->proformaparticuliersRepository->findBy(['statut' => false]);
        return $this->render('dashboard/includes/countNewsProformas.html.twig', [
            'countNewsProformasEntreprises' => count($proformaentreprises),
            'countNewsProformasParticuliers' => count($proformaparticuliers),
        ]);
    }

    public function getNewsProformaAdd(): Response
    {
        $proformaentreprises = $this->proformaentreprisesRepository->findBy(['statut' => false], ['id' => 'DESC']);
        $proformaparticuliers = $this->proformaparticuliersRepository->findBy(['statut' => false], ['id' => 'DESC']);
        return $this->render('dashboard/includes/NewsProformasListe.html.twig', [
            'proformaentreprises' => $proformaentreprises,
            'proformaparticuliers' => $proformaparticuliers,
        ]);
    }

    public function clientsSearchForm(Request $request): Response
    {
        //Formulaire de recherche de clients
        $search = new ClientsSearch();
        $form = $this->createForm(ClientsSearchType::class, $search);
        $form->handleRequest($request);

        $q = $request->query->get('q');
        $typeClient = $request->query->get('typeClient');

        return $this->render('dashboard/includes/clientsSearchForm.html.twig', [
            'client' => $search,
            'form' => $form->createView(),
            'q' => $q,
            'typeClient' => $typeClient
        ]);
    }

    #[Route('/search', name: 'generic.search', methods: ['GET', 'POST'])]
    public function searchForm(Request $request): Response
    {
        //Formulaire de recherche de clients
        $search = new ClientsSearch();
        $form = $this->createForm(ClientsSearchType::class, $search);
        $form->handleRequest($request);
        $search->page = $request->query->getInt('page', 1);
        $proformaparticuliers = [];
        $proformaentreprises = [];

        if ($search->getClientsType() === 'Particulier') {
            $proformaparticuliers = $this->proformaparticuliersRepository->recherche($search);
        } else {
            $proformaentreprises = $this->proformaentreprisesRepository->recherche($search);
        }

        return $this->render('dashboard/includes/searchForm.html.twig', [
            'client' => $search,
            'form' => $form->createView(),
            'title' => $search->q . ' - Recherche',
            'q' => $search->q,
            'typeClient' => $search->getClientsType(),
            'proformaparticuliers' => $proformaparticuliers,
            'proformaentreprises' => $proformaentreprises
        ]);
    }

    public function periodeProformaSearchForm(Request $request): Response
    {
        //Formulaire de génération de facture par période
        $search = new PeriodeProformaSearch();
        $form = $this->createForm(ProformaPeriodeType::class, $search);
        $form->handleRequest($request);
        return $this->render('dashboard/includes/periodeProformaSearchForm.html.twig', [
            'form_periode' => $form->createView(),
        ]);
    }

    public function periodeFactureSearchForm(Request $request): Response
    {
        //Formulaire de génération de facture par période
        $search = new PeriodeProformaSearch();
        $form = $this->createForm(ProformaPeriodeType::class, $search);
        $form->handleRequest($request);
        return $this->render('dashboard/includes/periodeFactureSearchForm.html.twig', [
            'form_periode' => $form->createView(),
        ]);
    }
}
