<?php

namespace App\Controller;

use App\Entity\Etatsreglements;
use App\Form\EtatsreglementsType;
use App\Managers\Managers;
use App\Repository\EtatsreglementsRepository;
use App\Services\Helpers\FlashServiceInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Routing\Requirement\Requirement;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[Route('/admin/etatsreglements')]
#[IsGranted(new Expression('is_granted("ROLE_SUPER_ADMIN")'))]
class AdminEtatsreglementsController extends AbstractController
{
    public function __construct(
        private readonly Managers              $manager,
        private readonly FlashServiceInterface $flash,
    )
    {
    }

    #[Route('/', name: "admin.etatsreglements.index", methods: ['GET', 'POST'])]
    public function index(EtatsreglementsRepository $etatsreglementsRepository, Request $request): Response
    {
        $etatsreglement = new Etatsreglements();
        $form = $this->createForm(EtatsreglementsType::class, $etatsreglement);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->manager->setEntity($etatsreglement, 'new');
            $this->flash->success("Enrégistrement effectué avec succès.");
            return $this->redirectToRoute('admin.etatsreglements.index');
        }
        return $this->render('admin/etatsreglements/index.html.twig', [
            'etatsreglement' => $etatsreglement,
            'form' => $form->createView(),
            'etatsreglements' => $etatsreglementsRepository->findAll(),
            'title' => 'Liste Etats de règlement',
            'libelle_ajouter' => 'Nouvelle etat de règlement',
            'active' => 'admin.etatsreglements.index',
        ]);
    }

    #[Route('/new', name: "admin.etatsreglements.new", methods: ['GET', 'POST'])]
    public function new(Request $request): Response
    {
        $etatsreglement = new Etatsreglements();
        $form = $this->createForm(EtatsreglementsType::class, $etatsreglement);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->manager->setEntity($etatsreglement, 'new');
            $this->flash->success("Enrégistrement effectué avec succès.");
            return $this->redirectToRoute('admin.etatsreglements.index');
        }

        return $this->render('admin/etatsreglements/new.html.twig', [
            'etatsreglement' => $etatsreglement,
            'form' => $form->createView(),
            'title' => 'Liste des etats de règlement',
            'libelle_liste' => 'Liste des etats de règlement',
            'libelle_ajouter' => 'Nouvelle etat de règlement',
            'active' => 'admin.etatsreglements.index',
        ]);
    }

    #[Route('/{id}/edit', name: 'admin.etatsreglements.edit', requirements: ['id' => Requirement::DIGITS], methods: ['GET', 'POST'])]
    public function edit(Request $request, Etatsreglements $etatsreglement): Response
    {
        $form = $this->createForm(EtatsreglementsType::class, $etatsreglement);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->manager->setEntity($etatsreglement, 'edit');
            $this->flash->success("Modification effectuée avec succès.");
            return $this->redirectToRoute('admin.etatsreglements.index', [
                'id' => $etatsreglement->getId(),
            ]);
        }

        return $this->render('admin/etatsreglements/edit.html.twig', [
            'etatsreglement' => $etatsreglement,
            'form' => $form->createView(),
            'title' => 'Editer un etat de règlement',
            'libelle_ajouter' => 'Nouvelle etat de règlement',
            'libelle_liste' => 'Liste des etats de règlement',
            'active' => 'admin.etatsreglements.edit',
        ]);
    }

    #[Route('/{id}', name: 'admin.etatsreglements.delete', requirements: ['id' => Requirement::DIGITS], methods: ['DELETE'])]
    public function delete(Request $request, Etatsreglements $etatsreglement): Response
    {
        if ($this->isCsrfTokenValid('delete' . $etatsreglement->getId(), $request->request->get('_token'))) {
            $this->manager->setEntity($etatsreglement, 'delete');
            $this->flash->success("Suppression effectuée avec succès.");
        }

        return $this->redirectToRoute('admin.etatsreglements.index');
    }
}
